/* swabsf.c
*
*	This program takes shortsams from the standard input, swaps bytes,
*	and spits them out on the standard output.  It's designed to convert
*	soundfiles between machines like VAXes and Suns.
*
*							Abe Singer
*/

static char *SccsId = "@(#) swabsf.c	1.3	(CMIL)	7/2/88	11:30:58 ";

#include <stdio.h>
#include <string.h>
#include <carl/defaults.h>
#include <carl/carl.h>

int	argc;
char	**argv;

main(ac, av)

int	ac;
char	*av[];

{
	short in, out;
	int ok, ttyflag;

	argc = ac;
	argv = av;

	ttyflag = isatty(fileno(stdout));

	if (getheader(stdin) != NULL) {
		if (strcmp(getprop(stdin, H_FORMAT), H_SHORTSAM))
			bail("Input must be shortsams!!", -2);
	} else
	      fprintf(stderr, "%s: Warning... no header.\n", argv[0]);

					/* Keep going until error/eof	*/
	while ((ok = getshort(&in)) > 0) {

		swab(&in, &out, sizeof(short));		/* Swap Bytes	*/

		if (ttyflag)		/* Print if stdout is tty	*/
			fprintf(stdout, "%d\n", out);
		else
			putshort(&out);	/* Otherwise, Spit it out...	*/
	}

	if (ok < 0) 			/* Bail on error		*/
		bail("Error reading soundfile from standard input", ok);

	swab(&in, &out, sizeof(short));	/* Do the last one...		*/
	if (ttyflag)			/* Print if stdout is tty	*/
		fprintf(stdout, "%d\n", out);
	else {
		putshort(&out);		/* Spit out the last one	*/
		flushshort();		/* Flush the output buffer	*/
	}
}

/* bail is a simple little routine which prints the name of the program
as it was called from the command line, an error message, and exits with
a given error code.						(als)
*/

int
bail(msg, errno)

char	*msg;
int	errno;

{
	char	*p;

#if 0
	p = strrchr(argv[0], "/") + 1;

	fprintf(stderr, "%s: %s\n", p, msg);
#endif
	fprintf(stderr, "%s: %s\n", argv[0], msg);

	exit(errno);
}
