#include "sndawk.h"
#include "sndawk.lx.h"
#include <stdio.h>

#ifdef CARL
#include <carl/carl.h>
#endif

extern FILE	*yyin;	/* le fichier utilise par lex */
char	*lexprog;	/* pointeur vers le texte du programme */


/*
 * yywrap c'est la fonction appele par lex quand il rencontre le EOF
 */
yywrap () {
    return (1);
}


SYMB * root, *yylex (); /* root c'est le pointeur vers la liste ou l'arbre du
			 * program. yylex retourne le lexeme suivant 
			 */
int	intty, otty;	/* indique si l'entre ou la sorti est un tty ou pipe */

main(argc, argv)
	int argc;	/* le nombre d'arguments de la ligne de commande */
	char *argv[];	/* le tableau des pointeur vers les champs de la ligne
			 * de commande */
{

	intty = isatty(0);
	otty = isatty(1);


/*
 * Si la ligne de commande ne contient que la commande
 */
	if (argc == 1){
		fprintf(stderr,"usage: sndawk [-f file | 'prog']\n");
		exit(-1);
	}

/*
 * Si le deuxime argumment est le flag "-f" le troisieme est le nom du fichier
 * ou se trouve le texte du programme. yyin pointe vers son descripteur.
 */
	if (argv[1][0] == '-' && argv[1][1] == 'f' && argv[1][2] == '\0') {
			yyin = fopen(argv[2], "r");
			if (yyin == NULL){
				fprintf(stderr, "can't open %s\n", argv[2]);
				exit(-1);
			}
		}

/*
 * Sinon le programme est le deuxieme argument de la ligne de commande 
 * (le premier etant la commande elle meme). lexprog pointe vers le texte.
 */
	else {
			yyin = NULL;
			lexprog = argv[1];
	}

    set_spec_var();

    analyse_lexicale();

    analyse_syntaxique();

    parsestr(root);

#ifdef DEBUG
    prettyprint (root, 0);
#endif

    execute(root);


/*
 * Si la sortie est un pipe on force les derniers flottants du buffer a sortir.
 */
#ifdef	CARL
    if(!otty) flushfloat();
#else
    if(!otty) fflush(stdout);
#endif
}
