#include <stdio.h>
#include "sndawk.lx.h"
#include "sndawk.h"

extern	IOSAMPS	*isamps, *osamps;
extern	VAR	*variables;
extern	SVAR	*svariables;
float	poubelle;
extern	float	*findioadd();
extern	float	eval();
extern	float	*findvaradd();

float	*findadd(symb)
	SYMB	*symb;
{
	float	index;
	float	delay, chan;

	switch(symb -> symbtype){
		case LVAR:
			index = (symb -> fils == NULL)?.0:eval(symb -> fils);
			if (index < 0.){
			    fprintf(stderr,
				"line %d\tindex is negative (%d)\n",
				symb -> line, (int) index);
			    exit(-1);
			}
			if (index > 64 * 1024){
			    fprintf(stderr,
				"line %d\tindex greater than 64K (%d)\n",
				symb -> line, (int) index);
			    exit(-1);
			}
			return(findvaradd(symb -> lexval.address, (int) index));
		case LSVAR:
			return( symb -> lexval.saddress -> acces ?
				&(symb -> lexval.saddress -> valeur):
				&poubelle);
		case LISAMPS:
		case LOSAMPS:
		    if((delay = eval(symb -> fils))
			> symb -> lexval.ioaddress -> delay){
			    fprintf(stderr,"line %d\tdelay is too big (%d)\n",
				symb -> line, (int) delay);
			    exit(-1);
		    }
		    if (delay < 0.){
			    fprintf(stderr,"line %d\tdelay negative (%d)\n",
				symb -> line, (int) delay);
			    exit(-1);
		    }
		    if((chan = eval(symb -> fils -> frered))
			> symb -> lexval.ioaddress -> chans){
			    fprintf(stderr,"line %d\ttoo many channels (%d)\n",
				symb -> line, (int) chan);
			    exit(-1);
		    }
		    if (chan < 1.) {
			    fprintf(stderr,
				"line %d\tchannel less than 1 (%d)\n",
				symb -> line, (int) chan);
			    exit(-1);
		    }
		    return(findioadd(symb -> lexval.ioaddress,
			(int) delay, (int) chan));
		default:
			return(&poubelle);

	}
}
