#include <math.h>
#include <stdio.h>
#include "sndawk.lx.h"
#include "sndawk.h"
#define	PI_ 3.1415927410125732

extern	IOSAMPS	*isamps, *osamps;
extern	float	samprate,interpol(),*findadd();
float	*debug;
extern	SVAR	*svar1, *svar2;

float   eval (symb)
        SYMB * symb;
{
	float temp, *f;

    switch (symb -> symbtype) {

	case LREAD:
	    f = findadd(symb -> fils -> fils);
#ifdef	CARL
	    if(!fgetfloat(f, symb -> fils -> frered -> lexval.file -> stream))
#else
	    if(!fread(f, sizeof(float), 1, 
			symb -> fils -> frered -> lexval.file -> stream))
#endif
		fprintf(stderr,"line %d: end of file\n",
					symb -> fils -> frered -> line);
	    return(*f);
	case LASGNOP:
/*
 * A l'adresse pointe par le champ valeur de la structure de type VAR pointe
 * par le champ lexval du fils du symbole on met l'evaluation de son frered.
 */
		switch(symb -> lexval.ival){
			case ADDEQ:
	    return(*(findadd(symb -> fils)) +=
					eval(symb -> fils -> frered));
			case SUBEQ:
	    return(*(findadd(symb -> fils)) -=
					eval(symb -> fils -> frered));
			case MULTEQ:
	    return(*(findadd(symb -> fils)) *=
					eval(symb -> fils -> frered));
			case DIVEQ:
	    return(*(findadd(symb -> fils)) /=
					eval(symb -> fils -> frered));
			case MODEQ:
	    return(*(findadd(symb -> fils)) =
			(float) ((int) eval (symb -> fils) %
			    (int) eval (symb -> fils -> frered)));
			case ASSIGN:
	    return(*(findadd(symb -> fils)) =
					eval(symb -> fils -> frered));
		}

	case LVIRGULE:
		eval (symb -> fils -> frered);
		return (eval(symb -> fils));

	case LNUM: 
	/* on retourne la valeur de la constante numerique */
	    return (symb -> lexval.fval);

	case LSVAR: 
	/* on retourne la valeur du champ valeur de la structure
	 * de type SVAR pointe par le champ lexval du symbole */
	    return (symb -> lexval.saddress -> valeur);

	case LISAMPS:
	case LOSAMPS:
	    return (*findadd(symb));
	case LVAR: 
	/* on retourne la valeur pointe par le champ valeur de la structure
	 * de type VAR pointe par le champ lexval du symbole */
	    return (interpol(symb));

	case LRELOP:
	case LOGOP:
	case LARTOP3: 
	case LARTOP1: 
	case LARTOP2: 
	/* on effectue l'operation indique par le champ lexval entre le fils
	 * et son frere droit */
	    switch (symb -> lexval.ival) {
		
		case LT: 
		    return ((float)(eval (symb -> fils) <
			    eval (symb -> fils -> frered)));
		case LE: 
		    return ((float)(eval (symb -> fils) <=
			    eval (symb -> fils -> frered)));
		case GT: 
		    return ((float)(eval (symb -> fils) >
			    eval (symb -> fils -> frered)));
		case GE: 
		    return ((float)(eval (symb -> fils) >=
			    eval (symb -> fils -> frered)));
		case EQ: 
		    return ((float)(eval (symb -> fils) ==
			    eval (symb -> fils -> frered)));
		case NE: 
		    return ((float)(eval (symb -> fils) !=
			    eval (symb -> fils -> frered)));
		case AND: 
		    return ((float)(eval (symb -> fils) &&
			    eval (symb -> fils -> frered)));
		case OR: 
		    return ((float)(eval (symb -> fils) ||
			    eval (symb -> fils -> frered)));
		case POW:
		    return (pow (eval (symb -> fils),
			    eval (symb -> fils -> frered)));
		case MOD:
		    return ((float) ((int) eval (symb -> fils) %
			    (int) eval (symb -> fils -> frered)));
		case PLUS: 
		    return (eval (symb -> fils) +
			    eval (symb -> fils -> frered));
		case MINUS: 
		    return (eval (symb -> fils) -
			    eval (symb -> fils -> frered));
		case MULT: 
		    return (eval (symb -> fils) *
			    eval (symb -> fils -> frered));
		case DIV: 
		    return (eval (symb -> fils) /
			    eval (symb -> fils -> frered));
	    }

	case LUNOP: 
	/* on retourne le "-" de la valeur de l'evaluation du fils */
	    return ( - eval (symb -> fils));

	case LPTINTER:
	/* si l'evaluation du fils direct de "?" retourne vrai on retourne
	 * l'evaluation du frered du fils, sinon celle du frered du frered */
	    if (eval (symb -> fils)) return (eval (symb -> fils -> frered));
		else return (eval (symb -> fils -> frered -> frered));

	case LFUNC:
	    switch (symb -> lexval.ival) {

		case FABS:
		    return (fabs(eval (symb -> fils)));
		case FLOOR:
		    return (floor(eval (symb -> fils)));
		case CEIL:
		    return (ceil(eval (symb -> fils)));
		case EXP:
		    return (exp(eval (symb -> fils)));
		case LOG:
		    return (log(eval (symb -> fils)));
		case LOG10:
		    return (log10(eval (symb -> fils)));
		case SIN:
		    return (sin(eval (symb -> fils)));
		case COS:
		    return (cos(eval (symb -> fils)));
		case TAN:
		    return (tan(eval (symb -> fils)));
		case ASIN:
		    return (asin(eval (symb -> fils)));
		case ACOS:
		    return (acos(eval (symb -> fils)));
		case ATAN:
		    return (atan(eval (symb -> fils)));
	}
	case LPOSTOP:
	    switch (symb -> lexval.ival) {
		case KILO:
		    return (1024. * eval(symb -> fils));
		case kilo:
		    return (1000. * eval(symb -> fils));
		case DB:
		    return (pow(10.0,eval(symb -> fils)/20.0));
		case SEC:
		    return (samprate * eval(symb -> fils));
		case HZ:
		    return (svar1 -> valeur * 2*PI_ / 
					(samprate / eval(symb -> fils)));
	}
	case LINCDEC:
	    switch (symb -> lexval.ival) {
		case INCR:
		    temp = *findadd(symb -> fils);
		    *findadd(symb -> fils) += 1.0;
		    return(temp);
		case DECR:
		    temp = *findadd(symb -> fils);
		    *findadd(symb -> fils) -= 1.0;
		    return(temp);
	    }
	case LDECINC:
	    switch (symb -> lexval.ival) {
		case INCR:
		    return (*findadd(symb -> fils) += 1.0);
		case DECR:
		    return (*findadd(symb -> fils) -= 1.0);
	}

	default: 
	    printf ("evalerror\n");
	    return (0.0);
    }
}
