#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <local/ircam.h>

int     sfd;
SFHEADER sfh;
struct stat sfstat;

main (argc, argv)
char  **argv;
{
    char    ch;
    int     result;
    char   *name;
    int     i,
            j;
    int     samp = 0,
            dur = 0,
            chan = 0,
            rate = 0,
            pack = 0,
            comment = 0,
            flag = 0,
            amp = 0,
            Amp = 0,
            chnl = 1;
    SFMAXAMP * sfm;
    float   typemax;
    char   *cptr,
           *data;

    while ((ch = argscan (argc, argv, "SdcCRPa|A|", "")) != NULL) {
	switch (ch) {
	    case 'C': 
		comment++;
		flag++;
		break;
	    case 'S': 
		samp = 1;
		flag++;
		break;
	    case 'd': 
		dur = 1;
		flag++;
		break;
	    case 'c': 
		chan = 1;
		flag++;
		break;
	    case 'R': 
		rate = 1;
		flag++;
		break;
	    case 'P': 
		pack = 1;
		flag++;
		break;
	    case 'a': 
		amp = 1;
		chnl = atoi (arg_option);
		flag++;
		break;
	    case 'A': 
		Amp = 1;
		chnl = atoi (arg_option);
		flag++;
		break;
	    default: 
		fprintf (stderr, "sndinfo: %s no such flag.\n", args_option);
/*		usage (1);	*/
	}
    }

    if (!args_count)		/* no default filename */
	usage (1);
    else			/* loop to get all files */
	for (j = 0; j < args_count; j++) {
	/* get the soundfile directory */
	    name = getsfname (args_vector[j]);

	/* open the file */
	    result = 0;
	    readopensf (name, sfd, sfh, sfstat, "sndinfo", result);
	    typemax = ((sfclass (&sfh) == SF_FLOAT) ? 1.0 : 32767.);

	    if (result == 0) {
		if (!flag)	/* when no flag was present print all the
				   information */
		    printf (
"\n%s:\t\t%s\n%s:\t\t%5.0f\n%s:\t%d\n%s:\t\t%s\n%s:\t\t\t%d %s\t%7.4f %s\n",
			    "Soundfile name", name,
			    "Sampling rate", sfsrate (&sfh),
			    "Number of channels", sfchans (&sfh),
			    "Packing mode",
			    sfclass (&sfh) == SF_SHORT ? "short" : "float",
			    "Length", sfbsize (&sfstat) / sfclass (&sfh),
			    "samples",
			    sfbsize (&sfstat) / sfchans (&sfh) / 
			    sfsrate (&sfh) / sfclass (&sfh),
			    "seconds");
		else {
		/* if there were flags print only asked values (useful for
		   shell scripts ex: set srate `sndinfo -R file`) */
		    if (samp)
			printf ("%d\n", sfbsize (&sfstat) / sfclass (&sfh));
		    if (dur)
			printf ("%f\n",
				sfbsize (&sfstat) / sfchans (&sfh) /
				sfsrate (&sfh) / sfclass (&sfh));
		    if (chan)
			printf ("%d\n", sfchans (&sfh));
		    if (rate)
			printf ("%f\n", sfsrate (&sfh));
		    if (pack)
			printf ("%d\n", sfclass (&sfh));
		}

	    /* 
	     * if maxamp code is in the header print maxamp information 
	     */

		if (!flag || amp || Amp) {
		    if ((cptr = (char *) getsfcode (&sfh, SF_MAXAMP)) != 0) {
			sfm = (SFMAXAMP *) (cptr + sizeof (SFCODE));
			if (!flag) {
			    printf ("Maximum amplitude:");
			    for (i = 0; i < sfchans (&sfh); i++) {
				printf ("\tChannel %d: ", i + 1);
				if (sfmaxamp (sfm, i)) {
				    printf ("%5d", (int) sfmaxamp (sfm, i));
				    printf ("(%.5f) at sample %d",
					    sfmaxamp (sfm, i) / typemax,
					    sfmaxamploc (sfm, i));
				    printf (" time:%6.3f sec\n\t\t",
					    sfmaxamploc (sfm, i) / 
					    sfsrate (&sfh));
				}
				else
				    printf (" silence\n");
			    }
			    printf("\r");
			}
			if (amp)
			    printf ("%f\n", sfmaxamp (sfm, chnl) / typemax);
			if (Amp)
			    printf ("%d\n", (int) sfmaxamp (sfm, chnl));
		    }
		}

	    /* 
	     * if a comment is in the header print it
	     */

		if (!flag || comment) {
		    if ((cptr = (char *) getsfcode (&sfh, SF_COMMENT)) != 0) {
			data = cptr + sizeof (SFCODE);
			if (!flag)
			    printf ("COMMENT:\n");
			printf ("%s", data);
			if(data[strlen(data)-1]!='\n')
				printf("\n");
		    }
		}
		close (sfd);
		if (!flag)	/* separate files with an empty line */
		    printf ("\n");
	    }
	}
}
usage (i)
int     i;
{
    fprintf (stderr,
	    "%s%s%s%s%s%s%s%s",
	    "\nusage: sndinfo [-CcPRSda] soundfile(s)\n",
	    "\t-C\tcomment\n",
	    "\t-c\tnumber of channels\n",
	    "\t-P\tpacking mode\n",
	    "\t-R\tsample rate\n",
	    "\t-S\tnumber of samples\n",
	    "\t-d\tduration in seconds\n",
	    "\t-a\tmaximum amplitude per channel\n");
    exit (i);
}
