
/*

Denis Lorrain, Mars 1986.

Compile with ...

	CFLAGS = -DUNIXFILES -O
	sndpan:	sndpan.o

*/

#ifndef LINT
static char *SccsId = "@(#) sndpan.c	1.2	(CMIL)	7/7/88	18:13:46 ";
/* sndpan.c	1.2	20/3/86		IRCAM */
#endif

# include <stdio.h>
# include <math.h>
# include <sys/types.h>
# include <sys/stat.h>
# include <sys/file.h>
# include <sfheader.h>

# define FAUX {fprintf(stderr,"Usage: sndpan In-sound Out-sound < Function\n");\
		exit(1);}
# define HEADSIZE 1024
# define MAXSHORT 65535.0
# define CHANS_OUT 2
# define EPSILON 0.00001

# define FLUSH	nbytesO = (frame * CHANS_OUT * SF_SHORT) % SF_BUFSIZE ;\
		if(write(sfd2,shortout,nbytesO) != nbytesO) {\
		fprintf(stderr,"Bad write to output file.\n");\
		close(sfd2);\
		close(sfd);\
		exit(1);\
		}
# define STOPERROR	close(sfd2);\
			close(sfd);\
			exit(1);

main(argc,argv)
int argc;
char *argv[];
{
	struct stat st;
	SFHEADER hd, hd2;
	char newname[HEADSIZE];
	char *cp, *cp2, *getsfname();
	int sfd, error = 0, sfd2;
	int	num,
		numO = 0,
		nsampsO,
		nbytesO,
		numI = 0,
		nframesI = 0,
		nbytesI
		;
	short *malloc(), *shortin, *shortout;
	unsigned short table[9001];
	long frame = 0, frame1, frame2, totinframes;
	double angle, angle1, time1, angle2, time2;
	double srate;
	double slopeangle;
	double cosinus, rad_deg;

	short	*sh;
	int	result;
	sh = (short *) &result;
	sh++;

/* Check parameters */
	if(argc != 3 ) FAUX;
	if(!strcmp(argv[1],argv[2])) FAUX;	

/* Open In-sound file */
	cp = getsfname(*++argv);
	if((sfd = open(cp,O_RDONLY)) == -1) {
		fprintf(stderr,"Can't find soundfile %s\n",cp);
		exit(1);	
	}		
	if(rheader(sfd,&hd)) {
		fprintf(stderr,"Bad header read for %s\n",cp);
		close(sfd);
		exit(1);
	}
	if(fstat(sfd,&st)) {
		fprintf(stderr,"Bad fstat() for %s\n",cp);
		close(sfd);
		exit(1);
	}
	if(sfchans(&hd) != 1) {
		fprintf(stderr,"More than one channel in %s\n",cp);
		close(sfd);
		exit(1);
	}
	if(sfclass(&hd) != SF_SHORT) {
		fprintf(stderr,"In-sound (%s) must be packed in short samples.\n",cp);
		close(sfd);
		exit(1);
	}
	srate = sfsrate(&hd);
	totinframes = (sfbsize(&st) / SF_SHORT) -1 ;

/* Open Out-sound file */
	strcpy(newname,*(argv+1));
	if((sfd2 = open(getsfname(newname),O_CREAT|O_TRUNC|O_WRONLY,0644))<0) {	
	      fprintf(stderr,"Can't create soundfile %s\n",getsfname(newname));
		close(sfd);
		exit(1);
	}
	hd2 = hd;
	sfchans(&hd2) = 2;
	if(wheader(sfd2,&hd2)) {
		fprintf(stderr,"Failed to write new header.\n");
		STOPERROR
	}
	nsampsO = SF_BUFSIZE / SF_SHORT;

/* Allocate buffers */
	if(((shortin = malloc(SF_BUFSIZE)) == NULL) || 
		((shortout = malloc(SF_BUFSIZE)) == NULL)) {
		fprintf(stderr,"Bad call to malloc.\n");
		STOPERROR
	}

/* Read first angle-time pair */
	scanf("%f%f",&angle1, &time1);
	if (time1 != 0.0) {
		fprintf(stderr,"First time point != 0\n");
		STOPERROR
	}
	frame1 = (time1 + EPSILON) * srate;
	if ((angle1 < 0.0) || (angle1 > 90.0)) {
		fprintf(stderr,"First angle not in [0,90]\n");
		STOPERROR
	}

/* Prepare table of cosine values for multiplying factors */
	rad_deg = 2.0*3.141592656/360.0;
	for (angle=0.0; angle<90.01; angle+=0.01) {
		cosinus = cos(rad_deg * angle) * MAXSHORT;
		num = (int) (angle * 100 + EPSILON);
		table[num] = (short) floor(cosinus + 0.5);
	}

/* (( 1 )) Read angle-time pairs loop */
while (scanf("%f%f",&angle2, &time2) != EOF){
	frame2 = (time2 + EPSILON) * srate;
	if (frame2 <= frame1) {
		fprintf(stderr,"Non-increasing time points at %f sec. of Function\n",time2);
		FLUSH
		STOPERROR
	}
	if ((angle2 < 0.0) || (angle2 > 90.0)) {
		fprintf(stderr,"Angle not in [0,90] at %f sec. of Function\n",time2);
		FLUSH
		STOPERROR
	}
	slopeangle = (double) ((angle2 - angle1) / (frame2 - frame1));
	angle = angle1;

/* (( 2 )) Read samples loop, inside a segments of angle function */
	for(frame=frame1; frame<frame2; frame++){
	if(numI == nframesI){
		nbytesI=read(sfd,shortin,SF_BUFSIZE);
		nframesI = nbytesI / SF_SHORT;
		if(nframesI <= 0){
		fprintf(stderr,"Bad read from input file.\n");
		FLUSH
		STOPERROR
		}
		numI = 0;
	}

	if(numO == nsampsO){
		if(write(sfd2,shortout,SF_BUFSIZE) != SF_BUFSIZE){
		fprintf(stderr,"Bad write to output file.\n");
		STOPERROR
		}
		numO = 0;
	}

	num = (int) (angle * 100 + EPSILON);

	result = shortin[numI] * table[num] ;
	shortout[numO] = *sh;
	numO++;
	num = 9000 - num;
	result = shortin[numI] * table[num] ;
	shortout[numO] = *sh;
	numO++;

	if(frame == totinframes) {
		frame++;
		FLUSH
		close(sfd2);
		close(sfd);
		fprintf(stderr,"End of In-sound.\n");
		exit(error);
	}

	angle += slopeangle;
	numI++;
	}
	

	frame1 = frame2;
	angle1 = angle2;
	time1 = time2;
}

	FLUSH
	close(sfd2);
	close(sfd);
	fprintf(stderr,"End of angle-time function.\n");
	exit(error);
}
