# include <stdio.h>
# include <sys/types.h>
# include <sys/file.h>
# include <sys/stat.h>
# include <ircam.h>

# define HEADSIZE 1024
# define TRUE 1
# define FALSE 0

SFCODE	ampc = {
	SF_MAXAMP,
	sizeof(SFMAXAMP) + sizeof(SFCODE)
}; 

SFMAXAMP *getmaxamp();

main(argc,argv)
int argc;
char *argv[];
{
	int sfd, error = 0, sfd2, outfloat = FALSE;
	struct stat st;
	SFMAXAMP *sfm;
	SFHEADER hd, hd2;
	register int i;
	int update, numbytes, sampcount;
	long sampframes, bytes, outbytes;
	float maxsamp = 0.0, multfac = 0.0, limiter = 1.0;
	float typemax;
	char *buffer, *malloc(), *outbuf, newname[HEADSIZE];
	char ch, *name, *cp2, *outname;
	long longval;
	unsigned short *shortptr, smultfac;
	short verbose = FALSE, newout = 0, result = 0;

if(argc < 2) 
	usage(1);

while(ch = argscan(argc,argv,"vfl|o|",""))  {
	switch(ch) {
		
		case 'v':
			verbose = TRUE;
			break;
		case 'f':
			outfloat = TRUE;
			break;
		case 'l':
			limiter = sfexpr(args_option,1.0);
			if(verbose)
			fprintf(stderr,"limiter = %f\n",limiter);
			break;
		case 'o':
			newout++;
			strcpy(newname,getsfname(args_option));
			if(verbose)
			fprintf(stderr,"newname = %s\n",newname);
			break;
		default:
			usage(1);
	}
}
	if(limiter > 1.0 || limiter < 0.0) {
		fprintf(stderr,"Error in limiter...Range: 0.- 1.\n");
		exit(1);
	}
    	if (!args_count--)		
		usage(1);
	if(args_vector[args_count] == NULL) 
		usage(1);
	update = 1;	/* ok to insert max amp into source soundfile */
   	name = getsfname (args_vector[args_count]);
	rdwropensf(name,sfd,hd,st,"sndnorm",result);
	if(result < 0) {
		update = 0;		
		readopensf(name,sfd,hd,st,"sndnorm",result);
		if(result < 0)
			exit(1);
	}
	hd2 = hd;
	sampframes = sfbsize(&st) / sfchans(&hd) / sfclass(&hd);
/*	typemax = (outfloat) ? 1.0 : 32767.;	*/
	typemax = 32767.;

/* If the maxamp is not already in the header, call getmaxamp()  */

	if(cp2 = (char *) getsfcode(&hd,SF_MAXAMP)) {
		sfm = (SFMAXAMP *)(cp2 + sizeof(SFCODE));
		if(!ismaxampgood(sfm,&st)) {
			fprintf(stderr,"Header info out of date. Updating\n");
			cp2 = NULL;
		}
	}

	if(cp2 == NULL)
		if((sfm = getmaxamp(sfd,update,0,sampframes)) == NULL) {
			fprintf(stderr,"Bad return from getmaxamp\n");
			exit(1);
		}

if(verbose) {
	printf("Maximum amplitude for file %s:\n",
			args_vector[args_count]);
	for(i=0; i<sfchans(&hd); i++) {
		printf("    Channel %d = ",i + 1);
		if(sfmaxamp(sfm,i)) {
		    printf("%6d (%.5f) sample frame: %ld",
			(int) sfmaxamp(sfm,i),
			sfmaxamp(sfm,i)/typemax, sfmaxamploc(sfm,i));
			printf(", time:%6.3f\n",
				sfmaxamploc(sfm,i)/sfsrate(&hd));
		}	
		else    
			printf("silence\n");
	}
}
/* Ready to rescale; maximum amp has been determined*/	
	
	for(i=0; i<sfchans(&hd); i++)
		if(sfmaxamp(sfm,i) > maxsamp)
			maxsamp = sfmaxamp(sfm,i);
	if(maxsamp == 0.) {
		fprintf(stderr,"Maxsamp is zero...sndnorm quitting.\n");
		exit(1);
	}

/*new*/
	multfac = (typemax / maxsamp) * limiter;
/*bug, only good if multfac < 1 */
	smultfac = multfac * 65536;	/*integer mult, longs*/
	shortptr = (unsigned short *)&longval;		/*addr of longval*/
	shortptr++;			/*point to highbytes, >32767*/

/* Open output file	*/

	if(!strcmp(args_vector[args_count],newname)) 
		usage(1);	
	if(!newout) {
	       strncpy(newname,args_vector[args_count],HEADSIZE-sizeof(".rs"));
	       strcat(newname,".rs");
	}
	outname = getsfname(newname);
	wropensf(outname,sfd2,hd2,"sndnrm2",result);
	if(result < 0)
		exit(1);
/* Allocate buffers and execute rescaling of file */

	if(((buffer = malloc(SF_BUFSIZE)) == NULL) || 
		((outbuf = malloc(SF_BUFSIZE * 2)) == NULL)) {
		fprintf(stderr,"Bad call to malloc.\n");
		exit(1);
	}

	sflseek(sfd,0L,0); /* reset source soundfile ptr to start of samples*/

	bytes = sfbsize(&st);
	 
	while(bytes>0) {
		if((numbytes = read(sfd,buffer,SF_BUFSIZE))<0) {
			fprintf(stderr,"Bad read from source file\n");
			exit(1);
		}

		sampcount = numbytes/sfclass(&hd);
		outbytes = sampcount * SF_SHORT;  /* default output int files*/
/*
 *floating point file in
 */
		if(sfclass(&hd) == SF_FLOAT) {	
		   register float *floatin = (float *) buffer, mf = multfac;

		   if(outfloat) { 
		        register float *floatout = (float *) outbuf, *bufend; 
			outbytes = sampcount * SF_FLOAT;  
			bufend = (float *) outbuf + sampcount;
			while(floatout < bufend)
				*floatout++ = *floatin++ * mf;
		   }
	           else {			
		        register short *shortout = (short *) outbuf, *sbufend; 
			sbufend = (short *) outbuf + sampcount;
			while(shortout < sbufend)
				*shortout++ = (short)(*floatin++ * mf);
		   }
		}   
/*
 * integer file input 
 */	
		else {
		    register short *shortin = (short *) buffer;
		    register short *shortout = (short *) outbuf, *sbufend;
		    if(!outfloat)  {	    /* integer file in and out */
			sbufend =  (short *) outbuf + sampcount;
			if(multfac < 1) {
		    		register unsigned short smf = smultfac;
				while(shortout < sbufend) {
					longval  = *shortin++ * smf;
					*shortout++ = *shortptr;
				}
			}
			else {
		        	register float mf = multfac;
				while(shortout < sbufend) {
					*shortout++ = *shortin++ * mf;
				}
			}
		   }
		   else {           /* integers in... floats out?? */ 
		        register float mf = multfac;
		        register float *floatout = (float *) outbuf, *bufend;
			outbytes = sampcount * SF_FLOAT;  
			bufend = (float *) outbuf + sampcount;
			while(floatout < bufend)
				*floatout++ = (float)(*shortin++ * mf);
		   }
		}
		if(write(sfd2,outbuf,outbytes) != outbytes) {
			fprintf(stderr,"Bad write to output file \n");
			exit(1);
		}
	   bytes -= numbytes;
	}

/* Update the header */

	for(i=0;i<sfchans(&hd2);i++)
			sfmaxamp(sfm,i) = sfmaxamp(sfm,i) * multfac;
	sfmaxamptime(sfm) = time(0);
	if(putsfcode(&hd2,sfm,&ampc)) {
		fprintf(stderr,"Bad attempt to update new header.\n");
		exit(1);
	}
	sfclass(&hd2) = ((outfloat) ? SF_FLOAT : SF_SHORT);
	lseek(sfd2,0,0);
	if(wheader(sfd2,&hd2)) {
		fprintf(stderr,"Failed to write new header to %s.\n",newname);
		close(sfd2);
		close(sfd);
		exit(1);
	}

/* Report new values */

if(verbose) {
	printf("\nNew maximum amplitude for file %s:\n",newname);
	for(i=0; i<sfchans(&hd2); i++) {
		printf("    Channel %d = ",i + 1); 
		printf("%6d (%.5f) sample frame: %ld",
			(int) sfmaxamp(sfm,i),
			sfmaxamp(sfm,i)/typemax, sfmaxamploc(sfm,i));
		printf(", time:%6.3f\n",
			sfmaxamploc(sfm,i)/sfsrate(&hd2));
	}
}
	close(sfd2);
	close(sfd);
	exit(error);
}
usage(exitcode)
	int exitcode;
{
	fprintf(stderr,"%s%s%s%s%s\n",
		"\nusage: sndnorm [flags] filename(s)\n",
		"\t-v\tverbose\n",
		"\t-f\toutput floating point file\n",
		"\t-o name\toutput filename\n",
		"\t-l n\tlimiter n (0. - 1.)\n");
	exit(exitcode);
}
