# include <stdio.h>
# include <signal.h>
# include "mixer.h"

savesfs()
{
#ifdef SAVE
	int unsavesfs();
	register struct SOUND_FILE *ptr;

	signal(SIGHUP,unsavesfs);
	signal(SIGINT,unsavesfs);
	signal(SIGTERM,unsavesfs);
	signal(SIGQUIT,unsavesfs);

	for(ptr = queue; ptr; ptr = ptr->right_activate) 
		if((ptr->savestatus = sfchmod(ptr->fname,SAVED)) == -1) {
			errs.errnum = SFSAVE;
			errs.str = ptr->fname;
			errs.arg.c = "marking";
			mixerr();
		}
#endif
}

unsavesfs(sig)
int sig;
{
#ifdef SAVE
	register struct SOUND_FILE  *ptr;

	for(ptr = queue; queue; ptr = ptr->right_activate)
		if(sfchmod(ptr->fname,ptr->savestatus) == -1) {
			errs.errnum = SFSAVE;
			errs.str = ptr->fname;
			errs.arg.c = "unmarking";
			mixerr();
		}
	exit(1);
#endif
}

