# include <stdio.h>
# include "mixer.h"

/* Procedure to reprot errors from the mixer program. Errors < NOPRINT are
   all fatal. */

mixerr()
{
	char *err = "ERROR!", *war = "WARNING";
	fprintf(stderr,"MIX: %s ",(errs.errnum < NOPRINT ? err : war));

	switch(errs.errnum) { 

	case NOFILE:   
		fprintf(stderr,"Sorry I can't access file %s\n",errs.str);
		break;
	case KEYWORD:  
		fprintf(stderr,"(line %d) %s is not on my list of keywords.\n",
			errs.arg.i,errs.str);
		break;
	case NOFDS:    
		perror("NOFDS");
		fprintf(stderr,"Wow! I ran out of file descriptors. File = %s\n",
			errs.str);
		unsavesfs();
		break;
	case NOOPTION: 
		fprintf(stderr,"I don't know the option [%s]\n",errs.str);
		break;
	case AMPFAC:   
		fprintf(stderr,"File %s has the absurd ampfac of %f\n",
			errs.str,errs.arg.f);
		break;
	case EMPTYFILE:
		fprintf(stderr,"Ha! File %s has a duration less than zero\n",
			errs.str);
		break;
	case SHORTFILE:
		fprintf(stderr,"File %s is not long enough.\n\tIts duration is %f\n",
			errs.str,errs.arg.f);
		break;
	case BADCHAN:  
		fprintf(stderr,"Output file has been set to %d channels.\n",outchans); 
		fprintf(stderr,"Only 1,2, or 4 allowed.\n");
		break;
	case NOOUTPUT: 
		fprintf(stderr,"Output file [%s] can't be created. Sorry\n",outfile);
		break;
	case NOMEM:    
		perror("NOMEM");
		fprintf(stderr,"Not enough memory available\n");
		break;

	case NOPRINT:  
		fprintf(stderr,"Output for the print option failed\n");
		break;
	case NOINPUT:  
		fprintf(stderr,"Not enough arguments on line %d\n",errs.arg.i);
		break;
	case ILLCHN:   
		fprintf(stderr,"Illegal channel specified for file %s, line number = %d\n",
			errs.str,errs.arg.i);
		break;
	case BADSRATE:    
		fprintf(stderr,
			"The sampling rate for file %s is %f.\n\tThe output file is %f!\n",
			errs.str,errs.arg.f,srate);
		break;
	case MIXEDMODE:
		fprintf(stderr,"File %s has %d channels, output file is %d ", 
			errs.str,errs.arg.i,outchans);
		fprintf(stderr,"channels, no send was given\n");
		break;
	case BADENV: 
		fprintf(stderr,"Envelope (file %s) has dup breakpoints at time %f\n",
			errs.str,errs.arg.f);
		break;
	case OVERFLOW: 
		fprintf(stderr,"Overflow at time %f\n",errs.arg.f);
		break;
	case GSKIP:    
		fprintf(stderr,"No files in range for partial mix\n");
		break;
	case SFSAVE:   
		fprintf(stderr,"Trouble %s file %s\n",errs.arg.c,errs.str);
		break;
	case SFTYPE:   
		fprintf(stderr,"File is not correct type (INT, FLOAT, SAMPLES).\n");
		break;
	case SFREAD:   
		perror("SFREAD");
		fprintf(stderr,"Bad read on file %s\n",errs.str);
		unsavesfs();
		break;
	case SFWRITE:  
		perror("SFWRITE");
		fprintf(stderr,"Bad write to output file\n");
		unsavesfs();
		break;
	case SKIP:     
		fprintf(stderr,"Bad skip on file %s\n",errs.str);
		unsavesfs();
		break;  
	case SFCLS:    
		fprintf(stderr,"Bad sfclose on file %s\n",errs.str);
		unsavesfs();
		break;
	case ILLUNIT:    
		fprintf(stderr,"Illegal mixunit specified = %d\n",errs.arg.i);
		break;
#ifdef UNIXFILES
	case BADHEADER:    
		fprintf(stderr,"Trouble with header for file = %s\n",errs.str);
		break;
#endif
	case SFFADE:    
		fprintf(stderr,"Fin or fout < 0 (line number %d)\n",
			errs.arg.i);
		break;
	case SFALIGN:    
		fprintf(stderr,"Read not aligned (file %s read = %d)\n",
			errs.str,errs.arg.i);
		break;
	case NOTSETUP:    
		fprintf(stderr,"No current input file - line %d ignored.\n",
			errs.arg.i);
		break;
	default:	
		fprintf(stderr,"Bad error number [%d]\n",errs.errnum);
		exit(1);
		break;
	}

	if(errs.errnum < NOPRINT) {    /* Fatal error? */
		fprintf(stderr,"Damn. Gotta stop mixin.\n");
		exit(1);
	}
}
