# include <stdio.h>
# include "mixer.h"
# include <sys/stat.h>

install(new)
register struct SOUND_FILE *new;
{
	/* Procedure to put structure new on the queue in ascending time order */

	register struct SOUND_FILE *count;
#ifndef UNIXFILES
	struct SFDESC sfdesc;
	short *cylptr;
#else
	int fd;
	SFHEADER header;
#endif
	struct stat statst;

	if(new->end.sft.s <= 0) { /* Duration not specified, use all of it */
#ifdef UNIXFILES
		if((fd = open(new->fname,READ)) < 0) {
			errs.str = new->fname;
			errs.errnum = NOFILE;
			mixerr();
		}
		if(rheader(fd,&header)) {
			errs.str = new->fname;
			errs.errnum = NOFILE;
			mixerr();
		}
		close(fd);
		if(header.sfinfo.sf_magic != SF_MAGIC) {
			errs.str = new->fname;
			errs.errnum = SFTYPE;
			mixerr();
		}
#endif UNIXFILES
		if(sfstat(new->fname,&sfdesc,&statst,&cylptr)) {
			errs.str = new->fname;
			errs.errnum = NOFILE;
			mixerr();
		}
		new->end.sft.s = (float) SFBSIZE / (SFSRATE * (float)
		    (SFCLASS * SFCHANS)) - new->offset.sft.s;
		fprintf(stderr,"File %s duration is %f\n",new->fname,new->end.sft.s);
	}

	/* If the queue is null then put this one on the queue as head and last
		   and return. */

	if(queue == NULL) {
		queue = last = new;
		return;
	}

	if(new->start.sft.s >= last->start.sft.s) {   /* add to the end of the queue */
		last->right_activate = new;
		new->left_activate = last;
		last = new;
	}
	else /* linear search */
	for(count = queue; count; count = count->right_activate) {
		if(new->start.sft.s <= count->start.sft.s) { /* We found its slot */
			if(count == queue) { /* New head node is needed */
				new->right_activate = queue;
				queue->left_activate = new;
				queue = new;
			}
			else { /* Not a head node */
				new->left_activate = count->left_activate;
				new->right_activate = count;
				new->left_activate->right_activate = new;
				count->left_activate = new;
			}
			break;
		}     /* End of we found the slot */
	}
}

