# define DOWN_ALIGN(x,y) while(x % y) x--

# include <stdio.h>
# include "mixer.h"

cmixem(tail_queue,samp_times,cur_unit)

struct SOUND_FILE *tail_queue;
long samp_times;
long cur_unit;
{

	float tempfac;
	register struct SOUND_FILE *ptr;
# ifndef vax
	register short sample_count;
# else vax
	short sample_count;
# endif
	int wnum,read_amount;
	short ch_count;
	long samp_count;
	int wamount, c_u;
	short  askfor, ask;
	register int ichans, ochans = outchans;

	for(samp_count = samp_times; samp_count > 0; 
		samp_count-= MIXUNIT,cur_unit += MIXUNIT) {

	 if(mixer_flags & CKAMP) 
	 	 foutput++; /* Force floating output buffer */
	 if(foutput)

#ifdef vax
	 	bzero(outflt,MIXUNIT * sizeof(float));
#else
	 	for(sample_count = 0; sample_count < MIXUNIT; sample_count++) 
	 		*(outflt + sample_count) = 0;
#endif
	 else
#ifdef vax
	 	bzero(outint,MIXUNIT * sizeof(short));
#else
 		for(sample_count = 0; sample_count < MIXUNIT; sample_count++) 
 			*(outint + sample_count) = 0;
#endif

 	/* Askfor remains in output samples */

 	askfor = (samp_count < MIXUNIT ? samp_count : MIXUNIT);
 	wamount = askfor * (foutput ? FLOAT : INT);
	if((mixer_flags & CKAMP) && foutput == 1)
		wamount /= INT;

 	for(ptr = queue; ptr != tail_queue->right_activate; ptr = ptr->right_activate) {
 		int in_count,out_count;
		register tin_count, tout_count, readnum;

#ifdef UNIXFILES
		 if(ptr->filed < 0)
			sfopn(ptr,MUSTHAVE);
#endif
		ichans = ptr->chans;
 		read_amount = (float) ichans / (float) ochans 
 			* (float) (askfor * ptr->class);

		if(read_amount % ptr->class) {
 			errs.errnum = SFALIGN;
 			errs.str = ptr->fname;
 			errs.arg.i = read_amount;
 			mixerr();
 		}

 		if(ptr->class == FLOAT) 
 			readnum = sfread(ptr->filed,inflt,read_amount);
 		else 
 			readnum = sfread(ptr->filed,inint,read_amount);

 		if(readnum == -1) {
 			errs.errnum = SFREAD;
 			errs.str = ptr->fname;
 			mixerr();
 		}

 		while(readnum < read_amount && (ptr->flags & LP)) {  /* 'loop' */
 			int more,ret;

 			/* Rewind */
 			if(sflseek(ptr->filed,ptr->offset.sft.l * ptr->class,0) == -1) {
 				errs.str = ptr->fname;
 				errs.errnum = SKIP;
 				mixerr();
 			}
 			/* Get remaining bytes */
 			more = read_amount - readnum;

 			if(ptr->class == FLOAT) 
 				ret = sfread(ptr->filed,((char *)inflt)+readnum,more);
 			else 
 				ret = sfread(ptr->filed,((char *)inint)+readnum,more);
 			if(ret == -1) {
 				errs.errnum = SFREAD;
 				errs.str = ptr->fname;
 				mixerr();
 			}
 			readnum += ret;
 		}
 		readnum /= ptr->class; /* To samples */
 		if(ptr->class != (foutput ? FLOAT : INT)) /* Conversion of input */
 			if(ptr->class == INT) ItoF(inint,inflt,readnum);
 			else FtoI(inflt,inint,readnum);


		c_u = cur_unit;
 		tempfac = ptr->ampfac;

 		if(ptr->more) { /* There are extras for this file */
 			short out_ch;
 			double tempamp,inc = 0,p2;
			long end_of_chunk;  
			int in_samps;
			struct envptr *eptr = NULL;
 			double tinc;
			short debug = 0;
			short max_out_count = 0;


		  /* increment in_start by input samps, out-start by output */
		  for(in_count = out_count = 0; in_count < readnum; c_u = cur_unit + out_count) { 
		   end_of_chunk = cur_unit + askfor; /* Default */
 		   tempfac = ptr->ampfac;

		   if(ptr->more->c_envptr && 
			ptr->more->c_envptr->env_start.sft.l <= c_u ) { /* Envelope */
			eptr = ptr->more->c_envptr;
 			if(eptr->env_end < end_of_chunk)
				end_of_chunk = eptr->env_end;

				
			tempfac *= (eptr->env_val + (eptr->env_diff * (float)
					(c_u - eptr->env_start.sft.l)));
			inc = eptr->env_diff;


			/* Does the envelope change in this buffer chunk 
			   After this don't use ptr->more->c_envptr until 
			   next time */
 			if(eptr->env_end <=  end_of_chunk) {
				ptr->more->c_envptr = eptr->env_next;
			}
		    }

		in_samps = (float) ichans / (float) ochans 
 			* (float) (end_of_chunk - cur_unit);


 			/* Amplitude scaling with extras */



 			for(ch_count = 0; ch_count < ichans; ch_count++)
 			 for(out_ch = 0; out_ch < ochans; out_ch++) {
			  tout_count = out_count + out_ch;
			  tin_count  = in_count + ch_count;
 			  if(ptr->more->send[ch_count][out_ch]) {
			   /* Starting location for channel */
 			   if((ptr->flags & PR) && eptr && eptr->env_diff)  /* Precise */

 			  	if(foutput)
 				 for(tempamp = tempfac * ptr->more->send[ch_count][out_ch],
 	  			    tinc = inc * ptr->more->send[ch_count][out_ch] * ochans;

 	  			    tin_count < in_samps;

 	  			    tin_count += ichans, tout_count += ochans,
 				  	tempamp += tinc) 
 				  *(outflt + tout_count) += (*(inflt + tin_count) * tempamp);
 				else /* short adder */
 				 for(tempamp = tempfac * ptr->more->send[ch_count][out_ch],
 	  			 tinc = inc * ptr->more->send[ch_count][out_ch] * ochans;

 	  			 tin_count < in_samps;

 	  			 tin_count += ichans, tout_count += ochans,
 				  tempamp += tinc) 
					

 				  *(outint + tout_count) += 
				  	(*(inint + tin_count) * tempamp);
 			
 			 else /* Not Precise */
 			  if(foutput)
 				for(tempamp = tempfac * ptr->more->send[ch_count][out_ch];

 	  			tin_count < in_samps;
			
 	  			tin_count += ichans, tout_count += ochans) 

 					*(outflt + tout_count) 
						+= (*(inflt + tin_count) * tempamp);
 			   else /* short adder */
 				for(tempamp = tempfac * ptr->more->send[ch_count][out_ch];
 	  			tin_count < in_samps;
 	  			tin_count += ichans, tout_count += ochans) 
 					*(outint + tout_count) += 
						(*(inint + tin_count) * tempamp);
		  }
		  max_out_count = (tout_count > max_out_count ? tout_count : max_out_count);
	  	  }
		  out_count = max_out_count;
		  DOWN_ALIGN(out_count,ochans);
		  in_count = in_samps;
 		 }	
		}/* End of Extras */
 		else /* No extras */ {
 		 if(tempfac != 1)
 			if(foutput)
 				for(tin_count = 0; tin_count < readnum; tin_count++) 
					*(outflt +tin_count) += tempfac * 
					 	*(inflt + tin_count);
 			else
 				for(tin_count = 0; tin_count < readnum; tin_count++) 
					*(outint +tin_count) += tempfac * 
						*(inint + tin_count);
 			else 
 			    if(foutput)
 				for(tin_count = 0; tin_count < readnum; tin_count++) 
					*(outflt +tin_count) += 
						*(inflt + tin_count);
 			else
 				for(tin_count = 0; tin_count < readnum; tin_count++) 
					*(outint +tin_count) += 
						*(inint + tin_count);
 		}
#ifdef UNIXFILES
		if(openfiles > MAXOPEN)
			sfcls(ptr,KEEP);
#endif
 	}  /* End of while each file in active queue */
 	if(mixer_flags & CKAMP) { /* Check for overflow in this chunk. */
 		isoverflow(cur_unit);
 		if(!(--foutput)) 
			FtoI(outflt,outint,askfor); /* Convert */
 	}
 	if(foutput) 
		wnum = sfwrite(outfd,outflt,wamount);
 	else 
		wnum = sfwrite(outfd,outint,wamount);

 	if(wnum != wamount) {
 		errs.errnum = SFWRITE;
 		mixerr();
 	}
 } /* For all chunks to be mixed */
}
