h14428
s 00009/00004/00141
d D 1.18 86/07/03 17:44:24 yocom 18 17
c yocom adjusted edition: notifies user it is creating mix.print
e
s 00007/00001/00138
d D 1.17 86/07/03 17:11:33 yocom 17 16
c yocom edition: mix.print is created by default if input from stdin
e
s 00003/00002/00136
d D 1.16 86/02/17 12:37:53 robert 16 15
c changed stderr to line buffered mode.
e
s 00007/00003/00131
d D 1.15 86/02/17 12:33:28 robert 15 14
c Sun seem to need stderr to be set to non-buffered mode.
e
s 00001/00000/00133
d D 1.14 85/09/02 20:28:18 robert 14 13
c Added 'full' keyword.
e
s 00000/00001/00133
d D 1.13 85/08/29 13:19:54 robert 13 12
c Took out unwanted auto mix.print.
e
s 00006/00006/00128
d D 1.12 85/08/27 21:39:05 robert 12 11
c Version with input for samples.
e
s 00001/00000/00133
d D 1.11 85/08/27 19:04:27 robert 11 10
c Just before change sample input.
e
s 00002/00000/00131
d D 1.10 85/08/26 15:38:35 robert 10 9
c Added a Ready (mostly for macmix).
e
s 00010/00003/00121
d D 1.9 85/07/29 19:52:59 robert 9 8
c Made global settings from command line sticky.
e
s 00005/00000/00119
d D 1.8 85/07/13 10:44:30 robert 8 7
c Added the -S flag and setup qprint for more than one mix.
e
s 00016/00011/00103
d D 1.7 85/07/12 22:42:31 robert 7 6
c Added the 'mix' keyword.
e
s 00004/00000/00110
d D 1.6 85/06/28 21:45:11 robert 6 5
c Version for unlimited number of input UNIX files.
e
s 00008/00006/00102
d D 1.5 85/06/25 20:28:44 robert 5 4
c Formatted for better printing. Works with sfname() for SFPATH.
e
s 00003/00003/00105
d D 1.4 85/06/25 12:02:41 robert 4 3
c 4.2 working version for UNIX files.
e
s 00003/00002/00105
d D 1.3 84/05/16 15:09:09 robert 3 2
c Working (I think) version for exact mixing.
e
s 00001/00003/00106
d D 1.2 84/05/11 16:54:00 robert 2 1
c First version of exact sample mixing. Robert
e
s 00109/00000/00000
d D 1.1 82/12/08 08:37:41 robert 1 0
c date and time created 82/12/08 08:37:41 by robert
e
u
U
t
T
I 1
# include <stdio.h>
# include "mixer.h"

D 3
static char SccsId[] = "%W%	%G%";
E 3
I 3
D 9
static char SccsId[] = "@(#)mixer.c	1.2	5/11/84";
E 9
I 9
D 17
static char SccsId[] = "%W%	%G%	IRCAM";
E 17
I 17
static char SccsId[] = "@(#)mixer.c	1.16	2/17/86	IRCAM";
E 17
E 9
E 3

/* Main body of the digital sound file mixer by R. Gross */
/* globals */

struct SOUND_FILE *queue,*dealloc_queue,*last,*endptr;
D 4
char outfile[16];
E 4
I 4
char outfile[1024];
E 4
int outfd;
struct mixerrs errs;
I 14
short full;
E 14
D 3
short mixer_flags = Q_MODE; /* Default to Quick mode */
E 3
I 3
short mixer_flags = (Q_MODE); /* Default to Quick and precise mode */
E 3
D 4
float srate = 20000.;
int outchans = 2;
E 4
I 4
float srate = 16000.;
int outchans = 1;
E 4
I 3
int MIXUNIT = DMIXUNIT;
E 3
D 12
union sft gskip,gdur;
I 9
union sft cgskip,cgdur;
E 12
I 12
struct sftime gskip,gdur;
struct sftime cgskip,cgdur;
E 12
short gdurplus, cgdurplus;
E 9
short foutput;     
I 8
short mixnumber;
E 8

I 6
#ifdef UNIXFILES
short openfiles;     
#endif

E 6
/*  buffers pointers */
short   *inint,*outint;
float   *inflt,*outflt;

main(argc,argv)

int argc;
char *argv[];
{
	char *s;        /* Option pointer */
	double atof();
I 7
	int done = 0;
I 17

D 18
/* if input from stdin, make a mix.print file */
	if(argc == 1) {
E 18
I 18
	if (argc == 1) {
E 18
		mixer_flags |= PRINT;
D 18
		fprintf(stderr,"mix.print being created for you.\n");
E 18
I 18
		fprintf(stderr,"mix.print is being created for you.\n");
E 18
	}
E 17
E 7
D 18

E 18
I 11
D 13
	mixer_flags |= PRINT;
E 13
E 11
D 7

E 7
	if(argc != 1) {
D 5
		while(--argc > 0 && (*++argv)[0] == '-') /* Handle seperate or
									     non seperate options */
E 5
I 5
		while(--argc > 0 && (*++argv)[0] == '-') 
E 5
			for(s = argv[0]+1; *s; s++)
				switch(*s)  {
				case 'c':       
					mixer_flags |= CHECK;   /* Just check syntax */
					break;
				case 'p':       
					mixer_flags |= PRINT;   /* print file of queue */
					break;
				case 'l':       
					mixer_flags |= CKAMP;   /* Do 32 bit math   
												   and check overflow */
					break;
				case 's':       
D 9
					gskip.s = (float) atof(*++argv);
E 9
I 9
D 12
					cgskip.s = (float) atof(*++argv);
E 12
I 12
					cgskip.sft.s = (float) atof(*++argv);
E 12
E 9
					argc--;
					break;
				case 'd':       
D 9
					gdur.s = (float) atof(*++argv);
E 9
I 9
					if(**++argv == '+') {
						cgdurplus = 1;
D 12
						cgdur.s = (float) atof(*argv+1);
E 12
I 12
						cgdur.sft.s = (float) atof(*argv+1);
E 12
					}
					else
D 12
						cgdur.s = (float) atof(*argv);
E 12
I 12
						cgdur.sft.s = (float) atof(*argv);
E 12
E 9
					argc--;
					break;
				case 'f':	
					foutput++;              
					break;
I 8
				case 'S':	/* Run silent */
					freopen("/dev/null","w",stderr);
					break;
E 8
				default:        
					errs.errnum = NOOPTION; 
					errs.str = s;
					mixerr();
				}
I 5

E 5
		if(argc == 1) /* Reopen stdin */
			if(freopen(*argv,"r",stdin) == NULL) {
				errs.errnum = NOFILE;
				errs.str = *argv;
				mixerr();
			}
	}

I 15
	/* This should not be needed but it seems  the suns reset
D 16
	   stderr to buffered mode when it is not a terminal */
E 16
I 16
	   stderr to buffered mode when it is not a terminal. This change
	   is mostly for mixd */
E 16

D 16
	setbuf(stderr,NULL);
E 16
I 16
	setlinebuf(stderr);
I 18

/* if input from stdin, make a mix.print file */
	if(argc == 0) {
		mixer_flags |= PRINT;
		fprintf(stderr,"mix.print being created for you.\n");
	}

E 18
E 16
E 15
D 7
	/* So, all specifications are on the standard input. Use procedure
E 7
I 7
	/* Loop until EOF for input file */
	do {

	/* All specifications are on the standard input. Use procedure
E 7
		setup to return a pointer to the head of the sequential run queue. */

D 7
	setup();
E 7
I 7
		if((done = setup()) < 0)
			exit(0);
E 7

	/* The start and end times must be set to the number of samples
D 2
		so that the mixer procedures can keep track of them. After sec2unit
		is used the times will be ajusted for block boundries and are in 
		multiples of MIXUNIT */
E 2
I 2
		so that the mixer procedures can keep track of them.  */
E 2

D 7
	sec2unit();
E 7
I 7
		sec2unit();
E 7

	/* If the options for global skip or dur is used then adjust the run
		   queue */

D 7
	if(gskip.s || gdur.s) adjustq();
E 7
I 7
D 12
		if(gskip.s || gdur.s) adjustq();
E 12
I 12
		if(gskip.sft.s || gdur.sft.s) adjustq();
E 12
E 7

	/* Now create the run queue of ascending stop times for the soundfiles. 
D 5
		An action time os either when a file start mixing into the output file
		or when a file must be taken off of the queue. */
E 5
I 5
	   An action time os either when a file start mixing into the output file
	   or when a file must be taken off of the queue. */
E 5

D 7
	dsetup();
E 7
I 7
		dsetup();
E 7

	/* Now we have two queues: One for start times and one for stop times */
	/* Check out the file specifications before starting to mix */

D 7
	check();
E 7
I 7
		check();
E 7

	/* If the print option was used then print out the run queue */

D 5
	if(mixer_flags & PRINT) qprint();
E 5
I 5
D 7
	if(mixer_flags & PRINT) 
		qprint();
E 7
I 7
		if(mixer_flags & PRINT) 
			qprint();
E 7
E 5

	/* If the Check flag was set then don't mix */

D 5
	if(!(mixer_flags & CHECK)) mixctl(); 
E 5
I 5
D 7
	if(!(mixer_flags & CHECK)) 
		mixctl(); 
E 7
I 7
		if(!(mixer_flags & CHECK)) 
			mixctl(); 
I 8
D 15
	mixnumber++;
I 10
	if(!done)
	fprintf(stderr,"Ready\n");
E 15
I 15
		mixnumber++;
		if(!done)
			fprintf(stderr,"Ready\n");
E 15
E 10
E 8
	} while(!done);
E 7
E 5
	exit(0);
}


E 1
