h17827
s 00002/00000/00091
d D 1.12 86/07/04 18:11:35 robert 12 11
c forgot sccs keywords
e
s 00002/00035/00089
d D 1.11 85/09/03 09:43:53 robert 11 10
c Use 'full' keyword to replace negative gskip, use STOP instead of truncating end times so fadeout + gdur works as expected.
e
s 00031/00008/00093
d D 1.10 85/09/02 20:28:03 robert 10 9
c Added 'full' keyword.
e
s 00027/00017/00074
d D 1.9 85/08/27 21:38:45 robert 9 8
c Version with input for samples.
e
s 00013/00005/00078
d D 1.8 85/08/27 19:04:21 robert 8 7
c Just before change sample input.
e
s 00007/00003/00076
d D 1.7 85/08/27 16:29:41 robert 7 6
c Allow negative gskip to control beginning gap.
e
s 00003/00001/00076
d D 1.6 85/07/29 13:05:54 robert 6 5
c Alignment of global skip and duration to outchans.
e
s 00001/00001/00076
d D 1.5 85/06/25 20:28:32 robert 5 4
c Formatted for better printing. Works with sfname() for SFPATH.
e
s 00002/00001/00075
d D 1.4 85/06/25 12:02:31 robert 4 3
c 4.2 working version for UNIX files.
e
s 00000/00000/00076
d D 1.3 84/05/16 15:08:58 robert 3 2
c Working (I think) version for exact mixing.
e
s 00002/00002/00074
d D 1.2 84/05/11 16:53:50 robert 2 1
c First version of exact sample mixing. Robert
e
s 00076/00000/00000
d D 1.1 82/12/08 08:37:24 robert 1 0
c date and time created 82/12/08 08:37:24 by robert
e
u
U
t
T
I 1
# include <stdio.h>
I 6
# define ALIGN(s,y) while((s) % (y)) (s)++
I 7
# define ROUND(s) ((s) +.5) 
I 8
# define ABS(s) ((s) < 0 ? -(s) : (s))
I 9
# define ISSEC(x) if((x.flags & TIME_IN_SAMP) == 0)  
# define FRAMEIT(x) (x).l = ((x).s * outchans)

I 12
static char *sccs_id =   "%W%	%G%";

E 12
E 9
E 8
E 7
E 6
# include "mixer.h"

/* Alter the queue to reflect the global skip and duration times */

adjustq()
{

	register struct SOUND_FILE *ptr;
	struct SOUND_FILE *temp;
	short got = 0;
I 8
D 9
	short wasneq = gskip.s < 0;
E 9
I 9
D 11
	short wasneq = gskip.sft.s < 0;
E 11
E 9
E 8

I 10
	/* If the gskip value is < 0 then leave the start times as is
	   let silence come in front of the queue. This should allow 
	   fade ins and fade outs to work if we catch them in the middle */

D 11
	if(full && !wasneq) 
		wasneq++;
		
E 10
D 2
	gskip.l = (long) (gskip.s * outchans * srate) / (long) MIXUNIT;
E 2
I 2
D 7
	gskip.l = (long) (gskip.s * outchans * srate); 
E 2
D 6

E 6
D 2
	gdur.l = (long) (gdur.s * outchans * srate) / (long) MIXUNIT;
E 2
I 2
	gdur.l = (long) (gdur.s * outchans * srate); 
E 7
I 7
D 8
	gskip.l = (long) ROUND(gskip.s * outchans * srate); 
	gdur.l = (long) ROUND(gdur.s * outchans * srate); 
E 8
I 8
D 9
	gskip.s =  ABS(gskip.s);
E 9
I 9
	gskip.sft.s =  ABS(gskip.sft.s);
E 9
E 8
E 7
E 2

E 11
I 8
D 9
	gskip.l = (long) ROUND(gskip.s * (float) srate) * (float) outchans; 
	gdur.l = (long) ROUND(gdur.s * (float) srate) * (float) outchans; 
E 9
I 9
	ISSEC(gskip)
		gskip.sft.l = (long) ROUND(gskip.sft.s * (float) srate) * (float) outchans; 
	else
		FRAMEIT(gskip.sft);
E 9
E 8
I 7

E 7
I 6
D 9
	ALIGN(gskip.l,outchans);
	ALIGN(gdur.l,outchans);
E 9
I 9
	ISSEC(gdur)
		gdur.sft.l = (long) ROUND(gdur.sft.s * (float) srate) * (float) outchans; 
	else
		FRAMEIT(gdur.sft);
E 9
E 6

I 9
	ALIGN(gskip.sft.l,outchans);
	ALIGN(gdur.sft.l,outchans);

E 9
	ptr = queue;
D 7
	if(ptr->start.l > gskip.l + gdur.l) {
E 7
I 7

D 10
	/* A negative gskip will produce a gap at beginning */
D 8
	if(gskip.l > 0L && ptr->start.l > gskip.l + gdur.l) {
E 8
I 8
D 9
	if(ptr->start.l > gskip.l + gdur.l) {
E 9
I 9
	if(ptr->start.sft.l > gskip.sft.l + gdur.sft.l) {
E 10
I 10
D 11

E 11
	if(gdur.sft.l && ptr->start.sft.l > gskip.sft.l + gdur.sft.l) {
E 10
E 9
E 8
E 7
		errs.errnum = GSKIP;
		mixerr();
	}

I 8
D 11

E 11
E 8
	while(ptr)  {
D 9
		if(ptr->end.l > gskip.l) {     /* First file in bounds */
E 9
I 9
		if(ptr->end.sft.l > gskip.sft.l) {     /* First file in bounds */
E 9
			queue = ptr; /* New head */
			queue->left_activate == NULL; /* Grounded pointer */
			got++;
			break;
		}
		else { /* Get rid of front files */
			queue = ptr->right_activate;
			free((char *) ptr);
			ptr = queue;
		}
	}

	if(!got) {      /* No file in bounds */
		errs.errnum = GSKIP;
		mixerr();
	}

I 8

E 8
	for(ptr = queue; ptr; ptr = ptr->right_activate) {
D 9
		if(ptr->end.l <= gskip.l) { /* delete file */
E 9
I 9
		if(ptr->end.sft.l <= gskip.sft.l) { /* delete file */
E 9
			ptr->left_activate->right_activate = ptr->right_activate; 
			ptr->right_activate->left_activate = ptr->left_activate;
			if(ptr->more) free(ptr->more);
			temp = ptr;
			ptr = ptr->left_activate; /* Backup one */
			free((char *) temp); 
			continue;
		}
D 8
		ptr->start.l -= gskip.l;
		ptr->end.l -= gskip.l;
E 8
I 8

D 11
		if(!wasneq) {
E 11
I 11
		if(!full) {
E 11
D 9
			ptr->start.l -= gskip.l;
			ptr->end.l -= gskip.l;
E 9
I 9
			ptr->start.sft.l -= gskip.sft.l;
			ptr->end.sft.l -= gskip.sft.l;
I 10
			if(ptr->start.sft.l < 0) { /* start time */
				ptr->offset.sft.l += -ptr->start.sft.l;
				ptr->start.sft.l = 0;
			}
E 10
E 9
		}
E 8
D 10

D 9
		if(ptr->start.l < 0) { /* start time */
			ptr->offset.l += -ptr->start.l;
			ptr->start.l = 0;
E 9
I 9
		if(ptr->start.sft.l < 0) { /* start time */
			ptr->offset.sft.l += -ptr->start.sft.l;
			ptr->start.sft.l = 0;
E 10
I 10
D 11
		else { /* File in middle */
E 11
I 11
		else { 
E 11
			if(ptr->start.sft.l < gskip.sft.l) {
				ptr->offset.sft.l += 
					((gskip.sft.l - ptr->start.sft.l) 
						/ outchans * ptr->chans);
				ptr->start.sft.l = gskip.sft.l;
			}
E 10
E 9
		}
I 10
D 11


#ifdef notdef
E 10
D 9
		if(gdur.l) {   /* Only if duration specified */
			if(ptr->end.l > gdur.l) ptr->end.l = gdur.l;
E 9
I 9
		if(gdur.sft.l) {   /* Only if duration specified */
D 10
			if(ptr->end.sft.l > gdur.sft.l) ptr->end.sft.l = gdur.sft.l;
E 10
I 10
			if(ptr->end.sft.l > gdur.sft.l) 
				ptr->end.sft.l = gdur.sft.l;
E 10
E 9
D 4
			if(ptr->right_activate && ptr->right_activate->start.l - gskip.l > gdur.l) { /* Last good one */
E 4
I 4
			if(ptr->right_activate && 
D 5
				ptr->right_activate->start.l - gskip.l > gdur.l) { /* Last good one */
E 5
I 5
D 9
				ptr->right_activate->start.l - gskip.l > gdur.l) { 
E 9
I 9
D 10
				ptr->right_activate->start.sft.l - gskip.sft.l > gdur.sft.l) { 
E 10
I 10
				ptr->right_activate->start.sft.l - gskip.sft.l 
					> gdur.sft.l) { 
E 10
E 9
E 5
E 4
				temp = ptr->right_activate;
				ptr->right_activate = NULL; /* End of queue */
				while(ptr) {
					temp = ptr;
					ptr = ptr->right_activate;
					free((char *) temp);
				}
				break;       /* All done */
			}
		}
I 10
#endif
E 11
E 10
	}
I 10
D 11
	/* Reset for qprint */
	if(wasneq)
		gskip.sft.l = -gskip.sft.l;
E 11
E 10
}
D 11


E 11
E 1
