#define CONV_BUFSIZE 	32768		/* (word) space in ds16 buffer */
#define KERN_BUFSIZE	16384		/* bytes in kernel xfer bufs */
#define AI_LOC 		0xD00000	/* physical address of ikon board */
#define BITS_24		0x00FFFFFF	/* to check 24 bit address exceeds */

#define ABS(x) ( (x < 0) ? -(x) : (x) )

struct ai_reg {
    short ai_csr;		/* ikon control/status register */
    short ai_data;		/* ikon data in/out */
    char ai_addr_mod;		/* ikon bus address modifier */
    char ai_vector;		/* interrupt vector assignment */
    short ai_pulse;		/* pulse command register */
    short fill[5];		/* nothing */
    short ai_DMA_wloaddr;	/* DMA address low (write) */
    short ai_DMA_range;		/* DMA range count */
    short ai_DMA_rloaddr;	/* DMA address high (read) */
    short fill2;		/* nothing */
    short ai_DMA_whiaddr;	/* DMA address high (write) */
    short fill3;		/* nothing */
    short ai_DMA_rhiaddr;	/* DMA address high (read) */
};

/* -----------------------------------------------------------------------
   interrupt control bits, signals, and flags
----------------------------------------------------------------------- */

/* ikon control settings */
#define IK_MSTR_CLR	0xF000	/* master clear on ikon, resets ds16 */
#define IK_CYC		0x0100	/* cycle DMA */
#define IK_GO		0x0001	/* DMA go! */
#define IK_INT		0x0040	/* enable ikon interrupt */
#define IK_CLEOR	0x8000	/* clear DMA end-of-range flag */
#define IK_EOR		0x8000	/* DMA end-of-range flag */
#define IK_CLR		0xC000	/* clear all flags; no reset */
#define IK_WCSR		0x0004	/* write to ds16 csr */
#define IK_WBUF		0x0000	/* write to ds16 data buffer */
#define	IK_RBUF		0x0002	/* read from ds16 data buffer */
#define IK_DSRESET	0x0008	/* toggle FCNT 3 for ds16 reset */


/* ds16 control settings */

#define DA_MONO		0x00CC
#define DA_STEREO	0x00EC
#define AD_MONO		0x00DC
#define AD_STEREO	0x00FC

/* Status bits */
#define AI_DONE         0x01    /* Conversion Done flag */
#define AI_BUSY         0x02    /* Disk transfer in progress */
#define AI_READY        0x03    /* All information loaded for conversion */


/* conv_type values */
#define DA      1
#define AD      2


/*  Macros used for the convert structure */

#define AIO_GETSTAT     _IOR(a, 1, short) 	    /* get control register */
#define AIO_RESET       _IO(a, 2)                   /* Reset ai device    */
#define AIO_STOP   	_IOR(a, 3, struct aud_conv) /* set conversion params */
#define AIO_GETSCAN     _IOR(a, 4, short) 	    /* scan buffers */
#define AIO_SET_DAC     _IOW(a, 5, struct aud_conv) /* setup dtoa */
#define AIO_SET_ADC     _IOW(a, 6, struct aud_conv) /* setup atod */
#define AIO_GO          _IOW(a, 7, struct aud_conv) /* kick it off */
#define AIO_SCAN	_IOR(a, 8, short) 	    /* scan buffers for peak */


/* defines for ds16 interrupt set */

#define LO_ENABLE 	0x0100	/* interrupt at 1/4 full */
#define HI_ENABLE 	0x0200	/* interrupt at 3/4 full */
#define DISABLE 	0x0000	/* clear interrupt */


/* ds16 buffer levels (ikon status lines) */

#define BUF_HI		0x0800	/* 3/4 full */
#define	BUF_LO		0x0400	/* 1/4 full */
#define BUF_MT		0x0200	/* buffer empty */


/* Flag settings */

#define IK_INTR		0x0100 	/* DMA interrupt */
#define IK_TIMEOUT	0x0010 	/* timeout flag */
#define IK_ONES		0xFFFF	/* for resetting, set all flags */
#define IK_ZEROS	0x0000	/* set conv_sigs to 0 */
#define IK_STOP		0x0001	/* end of conversion (set by user or eof) */
#define	IK_DONE		0x1000	/* halt conversion (last buf was sent */
#define SCAN_YES	0x0001	/* buffers may be scanned */
#define SCAN_NO		0x0000	/* buffers may not be scanned */
