/* %W%	%G% IRCAM 	(FROM -> 1.2	(CARL)	4/15/85) */

# include <sys/types.h>
# include <stdio.h>
# include <signal.h>
# include <sys/stat.h>
# include <sys/file.h>
# include <dsc.h>
# include <dsreg.h>
# include <disklock.h>
# include <sfheader.h>
# include <carl/sndio.h>
# include <carl/carl.h>

#define ADCBASE 00
#define DSCDMA0 0
#define DSMAXADC 2

extern float sample_rate;
extern int arg_index;
extern char *arg_option;
char *getsfname();

int verbose, retry, sync, syncval = 30, noreclaim;
char *convover;
int adcfid;
int disklocking;
int locklevel;



short convs[]={-1,-1,-1,-1,-1};

extern int quitearly(), noint(), usage();

int unixfd;
SFHEADER header;

main(argc, argv)
	int argc; char **argv;
{
	extern long setfilts();
	int status, pid, w;
	char ch;
	double fsrate = 32000.0, time = 5.0;
	int chans = 1;
	long stbyte, nsamps, fsamps, srate;
	int i, j, quiet=0;
	long filters = -1, brdmon = 0;
	long bytes;
	struct stat st,oldst;
	double atof();
	char *name = NULL;
	int had_holes= 0,getspace = 1;
	int timeout_val = 30 ,timeout();
	int exists = 0 ;

	arg_index=0;	/* reset crack */

	while ((ch = crack(argc, argv, "Ss|it|Gc|T|R|F|L|qvA|BM", 0)) != NULL) {
		switch (ch) {
		case 'F':	/* set filters */ 
			filters = atoi(arg_option);
			switch (filters) {
				case 0: default: filters = DS20KHZ; break;
				case 1:	filters = DS10KHZ; break;
				case 2:	filters = DSBYPAS; break;
				case 3:	filters = DS5KHZ; break;
			}
			break;
		case 'c':		/* chans */
			chans = atoi(arg_option);
			break;
		case 't':		/* timeout value */
			timeout_val = atoi(arg_option);
			break;
		case 'T':		/* Time in seconds */
			time = atof(arg_option);
			break;
		case 'R':		/* sampling rate  */
			fsrate = atof(arg_option);
			break;
		case 'G':		/* Kernel gets space */
			getspace = 0;
			break;
		case 'L':		/* verbose */
			disklocking++;
			locklevel = atoi(arg_option);
			break;
		case 'v':		/* verbose */
			verbose++;
			break;
		case 'i':		/* check if file exists */
			exists++;
			break;
		case 'S':		/* turn on sync from dh line */
			noreclaim++;
			break;
		case 's':		/* turn on sync from dh line */
			sync++;
			syncval = atol(arg_option);
			break;
		case 'A':		/* ADC override */
			convover = arg_option;
			break;
		case 'B': 
			brdmon = DSBRD;
			break;
		case 'M': 
			brdmon = DSMON; 
			break; 
		}
	}

	if(timeout_val > 60*6) {
		printf("Timeout value unreasonable (more than six minutes)\n");
		exit(1);
	}
	if(syncval < 0 || syncval > (60*6)) {
		printf("synctimeout (%d) is not valid\n",syncval);
		exit(1);
	}

	if(arg_index == argc) {
		printf("No filename specified\n");
		exit(1);
	}
	name = getsfname(argv[arg_index]);

	if(exists && !access(name,F_OK)) 
		if(!yes("File %s exists. Do you want to go on?\t", 0))
			exit(1);

	/* Use old file if it exists */
	if((unixfd = open(name, O_CREAT|O_RDWR,0644)) < 0) { 
		perror(name);
		exit(1);
	}

	if(chans < 1 || chans > 4) {
		printf("%d chans?\n",chans);
		exit(1);
	}

	if (convover == NULL) {	/* do the default converters */
		for (i = 0; i < chans; i++)
			convs[i] = ADCBASE + i;
	} else {
		for (i = j = 0; convover[i] != NULL && i < DSMAXADC; i++)
			if (convover[i] >= '1' && convover[i] <= '4') 
				convs[j++] = ADCBASE + convover[i] - '1';
	}

	srate = clck(fsrate); 	/* srate = 077 is 49152 KHz at CARL */

	if (filters == -1)	/* set filters */
		filters = setfilts(sample_rate, AD);

	bytes = (long) (time * sample_rate  * chans * SF_SHORT + sizeof(SFHEADER)); 

	/* Put header together */
	header.sfinfo.sf_magic = SF_MAGIC;
	sfsrate(&header) = sample_rate;
	sfchans(&header) = chans;
	sfclass(&header) = SF_SHORT;

	if(wheader(unixfd,&header)) { /* leave first siseof(SFHEADER) alone */
		printf("Write header failed\n");
		close(unixfd);
		exit(1);

	}

	fsamps = (bytes - sizeof(SFHEADER))/SF_SHORT; /* actual sound length */

	if (!quiet)
		printf("Actual duration= %f\n",
			(float) fsamps/(sfchans(&header) * sfsrate(&header)));
	if (!quiet)
		if(sfsrate(&header) != fsrate)
			printf("Actual sampling rate= %f\n",sfsrate(&header));

	nsamps = fsamps;

	if(fstat(unixfd,&oldst)) { /* get old size */
		perror("Bad stat\n");
		exit(1);
	}

	if((oldst.st_blocks * 512) < oldst.st_size) 
		had_holes = 1;

	/* Get size on new file. There might be holes in file */
	lseek(unixfd,bytes-4,1);
	if(write(unixfd,&bytes,4) < 0) {
		perror("Sizing (file unlinked)");
		close(unixfd);
		unlink(name);
		exit(1);
	}
	ftruncate(unixfd,bytes); /* real size asked for */

	if(fstat(unixfd,&st)) { /* get new size */
		perror("Bad stat\n");
		exit(1);
	}


	if((st.st_blocks * 512) < st.st_size) { /* holes in new file */
		if(!had_holes)   /* No holes in old */
			lseek(unixfd,(oldst.st_size + oldst.st_blksize -1)/
				oldst.st_blksize * oldst.st_blksize,0); /* end */
		else
			lseek(unixfd,0,0);

		bytes = st.st_size - lseek(unixfd,0,1);

		if(getspace) {
			if(verbose) {
				fprintf(stderr,"Need space (%d bytes)\n",
					bytes);
				fprintf(stderr,"Allocating (%d byte blocks) . .",
					st.st_blksize);
			}
			while(bytes > 0) { /* For now preallocate */
				lseek(unixfd,st.st_blksize-4,1);
				if(write(unixfd,&bytes-4,4) < 0) {
					perror("Allocating (file unlinked)");
					close(unixfd);
					unlink(name);
					exit(1);
				}
				bytes -= st.st_blksize;
			}
			ftruncate(unixfd,st.st_size); /* real size asked for */
			if(verbose)
				fprintf(stderr,"done\n");
		}
		else 
			if(verbose)
				fprintf(stderr,"Not allocating space. (%d bytes unallocated)\n",
					bytes);
	}


again:
	stbyte = 0;	/* For now no skips (sflseek() will skip header */
	/* Holds onto ADC at this moment so it can lock up if there is not
	   a timeout. */

	if ((adcfid = openadc()) < 0) { 
		fprintf(stderr, "can't get ADCs.\n"); 
		exit(1); 
	}

	signal(SIGALRM,timeout);
	alarm(timeout_val);

	if (!quiet) {
		char c, getans(); 

		printf("Press [RETURN] to %s, anything else to abort\t",
			sync ? "start sync" : "record");
		c=getans("");

		if (c != '\n') { 
			fprintf(stderr, "\naborting.\n"); 
			exit(1); 
		}
	}

	alarm(0); /* Cancel */

	if ((pid = fork()) == 0) {
		catchint(noint);	/* child throws interrupts away */

		if(disklocking) 
			lockdevs(DISKLOCK_LOCK,unixfd);

		if (dsadc(unixfd, adcfid, stbyte, nsamps, srate, filters, 
			1L, convs,  brdmon, st.st_blksize) < 0)
				exit(1);

		if(disklocking) 
			lockdevs(DISKLOCK_UNLOCK,unixfd);

		exit(0);
	}
	/* wait for process, or interrupts */
	catchint(quitearly);	/* parent catches interrupts , and child exit */
	while ((w = wait(&status)) != pid && w != -1) 
		/* empty */ ;
	if (w == -1) 
		status = 1;

	if (retry) { /* If there was a quit */
		retry = 0;
		sflseek(unixfd,0,0); /* Reset to just after header */
		goto again;
	}

	if (close(unixfd) != 0) { 
		fprintf(stderr, "close failed\n"); 
		status = 2; 
	}

	exit(status);
}

catchint(introutine)
	int (*introutine)();
{
	register int i;
	
		(void) signal(SIGINT, introutine);
		(void) signal(SIGQUIT, introutine);
}

noint() 
{ 
	/* empty */ 
}

quitearly(ind) 
	int ind;
{ 
	struct ds_fs dsf;
	long newloc;
	int rstfid;

	if (adcfid > 0) {
		/* get ending time */
		if (ioctl(adcfid, DSDONE, &dsf) == -1) {
			perror("DSDONE"); 
			return;
		}
		if ((rstfid = open(DEVDSR0, 0)) < 0) {
			perror(DEVDSR0);
			return;
		} else
			(void) close(rstfid);
		if (ind == SIGINT) { 
			/* BUG NEWLOC = BYTES NOT CONVERTED */
			newloc = dsf.bnosiz;
			if(newloc) 
				printf("\nrecording stopped at %6.3f seconds\n",
					(float) newloc / (float) ((sfclass(&header)  
					* sfchans(&header) * sfsrate(&header))));
			else
				if(sync)
					printf("\nsync mode stopped.\n");

			/* give up unused space */
			if(noreclaim || (newloc == 0 && sync)) 
				printf("Free space NOT reclaimed to actual duration\n");
			else
				ftruncate(unixfd,newloc + sizeof(SFHEADER));
		} else if (ind == SIGQUIT)
			retry++;
	} 
}

usage()
{
fprintf(stderr, "%s%s%s%s%s%s%s%s%s",
"record [flags] [file]\n",
"\tflags: flag = (values:default)\n",
"\tcN = set number of channels to N (1, 2, 4:1),\n",
"\tRN =sample rate (",
"32000.",
"),\n",
"\tFN = set filters to N (0,1,2,3:0),\n",
"\tq  = quiet mode,\n",
"\tTN = set file size to N (expressed as time in seconds),\n"
);
exit(1);
}

timeout(sig)
{
	printf("\nYou waited too long, must free up ADC unit.\n");
	exit(1);
}
