/* shellstr.c	1.2	(CARL)	8/10/84	12:11:35 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <carl/sndio.h>
#include <sys/file.h>
#include <sfheader.h>
#include <signal.h>
#include "play.h"

extern char shellstr[];	/* from interact.c */
int going = 0;

#define L16K (1024*16)
/*
 * #define PLOTSTRING "stripheader | /usr/local/lib/s2/voir3 %f %d 0. | gplot -q"
 */

#define PLOTSTRING "btoa | graph -a | sunplot"

shellcmd(fil, begin, end)
	int fil; long begin, end;
{
	long int i;
	int sfd;
	float sample;
	char *strptr = shellstr+1,*strsave();
	FILE *pp, *popen();
	int oldloc;
	extern int nfiles;

	if (shellstr[0] == '\0') {
		fprintf(stderr, "shellstr: no command!\n");
		return(-1);
	}

	sfd = pf[fil].sfp;
	oldloc = sflseek(sfd,(long) begin * SF_SHORT,0);

	switch(*shellstr) { 
	case 'A':
	case 'W': /* Write to UNIX file */
		{
		int flags,fd,n,bytes = (end - begin) * SF_SHORT;
		short buf[L16K/SF_SHORT];
		SFHEADER header;
		struct stat st;

		while(*strptr && *strptr <= ' ')
			strptr++;

		if(*strptr == NULL) {
			fprintf(stderr,"need a file name to Write\n");
			return(-1);
		}

		flags = O_CREAT | O_WRONLY | (*shellstr == 'W' ? O_TRUNC : 0);

		if(*shellstr == 'W')  /* Check file name */
			if(strcmp(strptr,pf[fil].cfile) == 0) {
				printf("File name is current input!.\n");
				return(-1);
			}

		if((fd = open(strptr,flags,0644)) < 0) {
			perror(strptr);
			return(-1);
		}

		if(fstat(fd,&st)) {
			perror("Stat");
			return(-1);
		}

		if(st.st_size  <= sizeof(SFHEADER))
			if(wheader(fd,&pf[fil].header))  {
				perror("header");
				return(-1);
			}
		lseek(fd,0,2); 

		while(bytes > 0) {
			if((n = read(sfd,(char *)buf,(bytes < L16K ? bytes : L16K))) < 0) {
				perror(strptr);
				return(-1);
			}
			if(n == 0) {
				printf("EOF on file - Stop.\n");
				break;
			}
				
			if(write(fd,(char *)buf,n) != n) {
				perror(strptr);
				return(-1);
			}
			bytes -= n;
		}
		close(fd);
		}
		break;
	case 'P':
	case 'p':

		{
			int fd,i,n,bytes = (end - begin) * SF_SHORT;
			short buf[L16K/SF_SHORT];
			float fbuf[L16K/SF_FLOAT];
			short *sp;
			float *fp;
			int onpipe();

			while(*strptr && *strptr <= ' ')
				strptr++;

			if(*shellstr == 'P' && *strptr == NULL) {
				fprintf(stderr,"Need pipe command\n");
				return(-1);
			}

			signal(SIGPIPE,onpipe);
			if(*shellstr == 'p') {
				char cmd[1024];
			
				sprintf(cmd,PLOTSTRING,sfsrate(&pf[fil].header),
					end- begin);
				pp = popen(cmd, "w");
			}
			else
				pp = popen(strptr, "w");

			if (pp == NULL) {
				perror("popen");
				return(-1);
			}
			if(whead(pp,&pf[fil].header,pf[fil].cfile))
				return(-1);
			going = 1;
			while(bytes > 0 && going) {
				if((n = read(sfd,(char *)buf,bytes < L16K ? bytes : L16K)) < 0) {
					perror(strptr);
					return(-1);
				}
	 
				if(n == 0) {
					printf("EOF on file. Stop.\n");
					break;
				}
				for(i = n/SF_SHORT,sp = buf, fp = fbuf;
					i > 0; i--) /* convert to floats */
						*fp++ = (float) *sp++;
	
				fwrite(fbuf,SF_FLOAT,n/SF_SHORT,pp);
				bytes -= n;
			}
			pclose(pp);
			signal(SIGPIPE,SIG_DFL);
		}
		break;
	case 'R':
		if(nfiles + 1 > MAXFILES) {
			fprintf(stderr,"Too many open files\n");
			return(fil);
		}
		while(*strptr && *strptr <= ' ')
			strptr++;
		pf[nfiles].cfile = strsave(strptr);
		if(setup(nfiles,pf[nfiles].cfile)) {
			fprintf(stderr,"setup failed \n");
			return(fil);
		}
		setsize(nfiles);
		pf[nfiles].end = pf[nfiles].size;
		nfiles++;
		cppsf(nfiles,nfiles-1);
		return(nfiles-1); /* Should be new one */
		break;

	default: /* Shell command */
		system(shellstr);
		break;
	}
	lseek(sfd,oldloc,0); /* Put it back */
	return(fil);
}

onpipe()
{
	going = 0;
}
