#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sfheader.h>

checkfile(name)
	char *name;
{
	int sfd;
	struct stat st;
	SFHEADER hd;


	sfd = open(name, 0);	/* open file */
	if (sfd < 0 ) {
		printf("play: can't find file %s\n",name); 
		return(-1);
	}
	if(rheader(sfd,&hd)) {
		printf("Bad header read on %s\n",name);
		goto bad;
	}
	if(hd.sfinfo.sf_magic != SF_MAGIC) {
		printf("%s not a soundfile? (magic = %d)\n",
			name,hd.sfinfo.sf_magic);
		goto bad;
	}
	if(fstat(sfd,&st)) {
		printf("bad stat on %s\n",name);
		goto bad;
	}
	close(sfd);
	if(sfclass(&hd) != SF_SHORT) {
		fprintf(stderr,"%s - sample size not playable (%d bytes/sample)\n",
			name,sfclass(&hd));
		goto bad;
	}
	return(0);
bad:
	close(sfd);
	return(-1);
}
