.\"	Note, a formatted version of this paper is named ../README
.TL
BICSF Berkeley/IRCAM/CARL Sound Filesystem  
.AB
BICSF is a
collection of programs which implement a filesystem for digital
audio applications running under Berkeley UNIX.
This document gives an overview and describes the installation procedure.
.AE
.SH
CREDITS
.LP
Contributors to this suite of programs are numerous, but the main
outlines of the system are due to the work of 
.IP \(bu
Marshall Kirk McKusick, William N. Joy,
Samuel J. Leffler, Robert S. Fabry
for the creation of the Berkeley Fast Filesystem,
.IP \(bu
Gareth Loy at CARL for the prototype CARL \fIcsound\fP(1carl) filesystem,
.IP \(bu
Rob Gross and Dan Timis at IRCAM for the IRCAM sound filesystem,
.IP \(bu
Brad Garton at Columbia for the Digisound-16
device driver and associated play and record programs.
.LP
The soundfile system code here is largely that of Rob Gross and Dan Timis of
the IRCAM group.  Author ascription has been appended to the manual
pages where known.
.LP
The device drivers were written by:
.IP \(bu
DSC-200: Rusty Wright at CARL,
.IP \(bu
Digisound 16: Brad Garton at Columbia Princeton,
.IP \(bu
Dyaxis: Susan Fichera at CARL.
.LP
The integration of these various sources into one package was done by
Gareth Loy and Abe Singer at CARL and CMIL.
.SH
LIST OF PROGRAMS AND ALIASES
.LP
Following is a list of programs and aliases, and brief descriptions:
.DS
ALIASES USING STANDARD UNIX COMMANDS
catsf	\- concatenate soundfiles
chgrpsf	\- change soundfile group ownership
chmodsf	\- change soundfile mode 
chownsf	\- change soundfile ownership
cpsf	\- copy soundfile
mkdirsf	\- make soundfile directory
mvsf	\- move a soundfile
pwdsf	\- print working soundfile directory
rmdirsf	\- remove (empty) soundfile directory
rmsf	\- remove soundfile (or directory tree)
.DE
.sp
.DS
BACKWARD COMPATABILITY
sndin	\- read from soundfile
sndout	\- write to soundfile
.DE
.sp
.DS
SPECIAL PROGRAMS
createsf	\- prepare soundfile for recording
fromsf	\- read from soundfile
gainsf	\- normalize or adjust gain of soundfile
lsf	\- list sound files
normsf	\- normalize amplitude of soundfile
pansf	\- pan sound file
peaksf	\- compute peak amplitude and record in soundfile header
querysf	\- print out contents of header
restorsf \- restore soundfile from csound dumpsf tape
retrosf	\- retrograde a soundfile
scalesf	\- gain scale a soundfile
setsf	\- set or modify soundfile header parameters
sndawk	\- signal modification language similar to awk for soundfiles
swabsf	\- swap bytes of samples in soundfile
tarsf	\- tape archive of soundfiles
tosf	\- write to soundfile
transpsf	\- transpose pitch of soundfile
xdr	\- convert soundfile to Sun external data representation
.DE
.sp
.DS
PLAYBACK/RECORD/MONITOR PROGRAMS
monitor	\- monitor digital output of ADCs
play	\- play soundfile
record	\- record soundfile
.DE
.SH
NAMES OF PROGRAMS
.LP
In the interests of name coherency, some programs have been
renamed from their original forms at CARL, IRCAM, and Columbia-Princeton.
.DS
PROGRAMS:
.ta 2i
ORIGINAL	RENAMED
sfcreate	createsf
sndcat	catsf
sndgain	gainsf
sndin	fromsf
sndinfo	querysf
sndnorm	normsf
sndout	tosf
sndpan	pansf
sndpeak	peaksf
sndreverse	retrosf
sndscale	scalesf
sndset	setsf
sndtransp	transpsf
.DE
.sp
.DS
PLAY, RECORD, ETC:
DigiSound-16:	ai{play,record,monitor,reset}
Dyaxis:	dy{play,record}
DSC-200:	ds{play,record}
.DE
.LP
Aliases have been created for all the original names, and are listed
along with the rest of the aliases in 
.I ./bicsf/std.sfaliases.m4.
.SH
ORGANIZATION OF SOFTWARE
.LP
Software is divided into three groups:
.IP \(bu
device drivers, found in subdirectory \fI../sys\fP,
.IP \(bu
applications programs which depend upon type of converters,
found in subdirectories \fI./{ds,ai,dy}play\fP and \fI./{ds,ai,dy}record,\fP
.IP \(bu
soundfile manipulation and signal processing programs (found
in the rest of the directories).
.SH
BRIEF THEORY OF OPERATION
.LP
Using BICSF, one is presented with two current working directories:
one's regular UNIX current working directory (cwd), 
plus the BICSF cwd, which is initialized to
point to one's home soundfile directory.  Soundfiles are ordinarily partitioned on a
separate disk from other files.  However, the BICSF soundfile directory
is really a standard UNIX filesystem at bottom.
Having soundfiles on separate disks from
regular UNIX disks avoids competition for head movement with
regular UNIX processes.  It is also advisable where possible to have
a separate disk controller for soundfile disks to improve throughput for
high sampling rates.
.LP
There are several reasons to segregate soundfiles from regular UNIX files.
.IP \(bu
Conventional wisdom is that
the block/fragment size of the soundfile partitions should be set to
their maximum (currently 8K blocks and 8K fragments).  This is 
desirable for maximum disk throughput.  The bigger the blocks, the
more efficient the disk I/O can be.
But UNIX files tend to favor smaller granularization, since there tend
to be more of them, and they tend to be small.  It is more common to have
UNIX partitions set to 4k/512 to allow more effective filling of the disk.
Thus, the two types of files demand different treatment to optimize space
(for UNIX files) and speed (for BICSF files).
.IP \(bu
System administration: soundfiles are BIG.  It is better to have them
separate from regular UNIX files so you don't have to do
huge system dumps of user's home directory trees.
In fact, at CARL, we do not dump soundfile systems, but leave
this to the users to do as they see fit.
.IP \(bu
Speed of throughput: you do not want realtime sound I/O to be in
competition with timesharing I/O.  Expect an increase of up to 50%
for having a separate disk and controller for sound.
.LP
The idea of simultaneous working directories for UNIX and BICSF filesystems
overcomes the problem of having to name long absolute pathnames to get
to one's soundfiles.  This implementation (developed by Robert Gross)
consists of a set of aliases listed in 
.I ./bicsf/std.sfaliases.m4.
An environment variable 
.I SFDIR 
contains the current working soundfile
directory.  The UNIX 
.IR pwd (1) 
command has a BICSF counterpart with
the following definition:
.DS
.ta 1i 2i
alias	pwdsf	'(cd $SFDIR; /bin/pwd \\\\!*)'
.DE
Likewise, the UNIX 
.IR cat (1) 
command has this counterpart:
.DS
.ta 1i 2i
alias	catsf	'(cd $SFDIR; /cmil/bin/catsf \\\\!*)'
.DE
.I cdsf, 
the BICSF equivalent of 
.IR cd (1)
sets the 
.I SFDIR 
variable (it's definition repays careful study).  
All BICSF programs must have such an alias as shown above.  
.SH
ADJUSTING FOR LOCAL CONDITIONS
.LP
You should inspect the aliases in 
.I std.sfaliases.m4 
and 
.I std.cshrc.m4 
to make sure they
agree with local requirements.  In particular, check the play, record, and
monitor aliases in 
.I std.sfaliases.m4, 
and set them to execute the play/record programs
for the converters you are using.  Also check values of
\fIBINSF, ROOT_SFDIR, HOME_SFDIR,\fP and \fISFDIR\fP for local conditions.
.LP
When the system is installed, these two files are run through the UNIX
.IR m4 (1)
macro preprocessor to resolve the location of the programs the aliases refer to.
.I m4
macros defining standard pathnames for executables, manual pages, libraries,
alias files, sources, etc. must
be listed in the file \fIconfig.m4,\fP usually located in
.I /usr/include/carl/config.m4.
See \fIconfig.m4\fP(1carl) for details.
.SH 
SOURCES
.LP
Sources may be placed in one of several places depending upon local conventions.
At CARL, this path is 
.I /carl/src/carl/src/bicsf.  
Elsewhere,
a good place to put it (or find it)
is 
.I /`hostname`/src/import/carl/src/bicsf,
where 
.I `hostname`
is the name of your machine.
.PP
The applications programs depend upon a library: 
.I libbicsf.a.
After creation, this library may be in one of several
places, depending upon local conventions.
At CARL, this path is 
.I /carl/lib/libbicsf.a.
Elsewhere, a good place to put
it (or find it) is 
.I /`hostname`/lib/libbicsf.a.
.PP
It can also be put in 
.I /usr/local/lib/libbicsf.a, 
but as this area is usually wiped out
across upgrades of UNIX, it is preferable to make a symbolic link,
\fI/usr/local/lib \-> /`hostname`/lib.\fP
In this way, the loader,
.IR ld (1)
can still find local libraries, allowing the loader's \-l flag convention:
.RS
% cc file.c \-lbicsf
.RE
to succeed.
Otherwise, a full path to the file could be given:
.RS .5i
% cc file.c /`hostname`/lib/libbicsf.a
.RE
.LP
Include files in the source code all make generic references to include files.
The Makefiles in each directory are made from their 
.I Makefile.m4 
prototypes
in each source directory, and compile the programs to look in the correct
locations for include files.  These are almost universally relative paths
to the directory
.I ./include
(except for device drivers).
.SH
HARDWARE INSTALLATION
.LP
Besides the installation of your converters, it is important to block
out appropriate partitions for BICSF soundfile partitions, and give
them the proper block/fragment sizes.  Conventional wisdom is that you want to set
them to 8K/8K block/fragment size.   The larger the block/fragment size,
the more efficient the disk can be in reading/writing data.
If possible, you do want sound on a separate physical
disk, not sharing any other UNIX function, including swapping, etc.
It's also useful if sound disks are on separate controllers.
CARL benchmarks are that a Digisound-16 can run 48,000Hz stereo
from a Fujitsu Eagle with a single Xylogics 450 controller on a Sun-3
with a little spare bandwidth.  A second controller helps a lot.
There are some files in the device driver directories for the 
.I ai
driver (for the Digisound-16) which suggest further performance enhancements.
.SH
DEVICE DRIVER INSTALLATION
.LP
Refer to the appropriate subdirectory in 
.I ../sys 
for the type of
converter you have and follow the directions you find there.
.LP
.SH
SOFTWARE INSTALLATION
.LP
The code is installed using standard CARL Software conventions.
If this code is being installed as part of the CARL Software Distribution,
the process should be mostly automatic, save for the installation of
the device drivers.  Refer to the instructions for the Distribution, but
all that need be done is to first say
.DS
	make
.DE
then
.DS
	make install
.DE
and finally
.DS
	make clean
.DE
.LP
To install standalone, proceede as follows:
.LP
First, you need a copy of libcarl.a, from the CARL software distribution
to compile some routines, so don't bother unless you have one elsewhere,
or are willing to do writearounds (which wouldn't be too difficult) for the
missing routines.
.LP
Edit the file 
.I ./include/config.m4, 
which contains default and built-in
pathnames for programs.  For standalone installation, the
most important are m4SNDFILESYSTEM, m4INCLUDE, m4DESTDIR, and m4MANDIR.
.LP
Then execute the file ./Makefirst as follows:
.DS
	% make -f Makefirst
.DE
This creates the subdirectory 
.I /usr/include/carl, 
and puts the file
.I ./include/config.m4
in it.  It is strongly advised that this subdirectory
be used.  If you want to put it somewhere else, you must edit all
.I Makefile.m4
files in this directory tree to point to the new directory,
plus change any C program files that make reference to 
.I /usr/include/carl.
There is a script to change the makefiles called ./misc/fixmakefiles that
you can use to expedite this process, if necessary.
.LP
Next, say
.DS
	% make
.DE
which does the following steps:
.IP \(bu
remakes all Makefiles with correct paths,
.IP \(bu
installs the remaining include files in 
.I /usr/include/carl,
.IP \(bu
builds the library
.IP \(bu
compiles application programs.
.LP
Next say
.DS
	% make install
.DE
which will install binaries, manual pages, and system aliases.
.LP
Lastly, say
.DS
	% make clean
.DE
to remove executables and .o files.
.LP
To run off documentation, say 
.DS
	$ make roffall
.DE
.SH
SYSTEM ALIASES
.LP
The contents of 
.I ./bicsf/std.sfaliases
must somehow be sourced by
all users when they log in.  Furthermore, it is useful to have
users refer to a master copy, so that as BICSF programs come and go,
a single file only needs be changed.  At CMIL, for instance, this is done as follows.
.LP
All users have a standard 
.I .cshrc 
file in their home directories which contains the following line:
.DS
source /`hostname`/lib/std.cshrc
.DE
where 
.I `hostname`
is either the name of the machine, or some other well-known local path.
The file
.I std.cshrc
in turn sources
.I /`hostname`/lib/std.sfaliases,
which initializes shell variables and establishes the system aliases for BICSF commands.
.LP
There is a prototype .cshrc file, 
.I ./bicsf/dotcshrc,
which is provided for convenience.
These should be the basis of the .cshrc files all
users have.  At CARL, we have an 
.I adduser 
shell script which installs
new users.  Part of it's task is to copy dotcshrc
to ~newuser/.cshrc.
