# include <stdio.h>

#ifndef LINT
static char SccsId[] = 	"%W%	%G%	IRCAM";
#endif

# include <sys/types.h>
# include <sys/stat.h>
# include <sys/file.h>
# include <carl/ircam.h>

# define TRUE 1
# define FALSE 0

/*	catsf joins soundfiles sequentially. 
	Channel assignments remain unchanged.
	An integer(playable) file named "catfile" is output.
*/

main(argc,argv)
int argc;
char *argv[];
{
	int i, maxchans = 1, chanfac, sfd, sfd2, stereo = 0, firstsr = 1;
	struct stat st;
	SFHEADER hd, hd2;
	int numbytes, result, sampcount, bufnum, first = 1, error = 0;
	short verbose = FALSE, newout = 0;
	long bytes, outbytes;
	char *inbuf, *malloc(), *outbuf, newname[1024], *getsfname();
	char ch, *name, **argptr, c;
	float dur = 0.,ratefac,srate = 0.;
	double atof();

	if(argc < 2 ) 
		usage(1);

	i = argc;
	argptr = argv;
	while((ch = crack(argc,argv,"vf|R|",TRUE)) != NULL) {
		switch(ch) {
		case 'v':
			verbose = TRUE;
			break;
		case 'f':
			newout++;
			strcpy(newname,getsfname(arg_option));
			break;
		case 'R':
			srate = atof(arg_option);
			break;
		default:
			if(verbose)
				fprintf(stderr,"Unrecognized flag\n");
			break;
		}
		i--;
		argptr++;
	}

	/* Check the files to be joined */

	argc = i;
	argv = argptr;
	while(--i) {
		name = getsfname(*++argptr);
		readopensf(name,sfd,hd,st,"catsf",result);
		if(result < 0) {
			if(verbose)
				fprintf(stderr,"\tIt will be left out of the queue.\n");
			error++;
		}
		else {
			if(firstsr) 
				if(!srate)
					srate = sfsrate(&hd);
			firstsr = 0;

			maxchans = (sfchans(&hd) > maxchans)? sfchans(&hd):maxchans;
			ratefac = sfsrate(&hd) / srate; 
			dur += (ratefac * ((float)sfbsize(&st)/
			    (sfchans(&hd)*sfsrate(&hd)*sfclass(&hd))));
		}
		close(sfd);
	}	

	/* Files are checked, ready to go */

start:	
	while(--argc) {

		name = getsfname(*++argv);
		readopensf(name,sfd,hd,st,"catsf",result);
		if(result < 0) {
			close(sfd);
			if(verbose)
				fprintf(stderr,"\t...skipping %s\n",name);
			goto start;
		}
		chanfac = maxchans / sfchans(&hd);
		if(sfchans(&hd) == 2)
			stereo = TRUE;
		hd2 = hd;	

		/* Open output file	*/

		if(first) {
			if(!newout)
				strcat(newname,"catfile");
			if((sfd2 = open(getsfname(newname),O_CREAT|O_TRUNC|O_WRONLY,0644))<0) {	
				fprintf(stderr,"Can't create soundfile %s\n",newname);
				close(sfd);
				exit(1);
			}
			first = 0;
			sfsrate(&hd2) = srate;
			sfchans(&hd2) = maxchans;
			if(wheader(sfd2,&hd2)) {
				fprintf(stderr,"Failed to write new header.\n");
				close(sfd2);
				close(sfd);
				exit(1);
			}
		}
		if(verbose) {
			fprintf(stderr,"Reading %s\t",*argv);
			fprintf(stderr,"SR = %d\tnchans = %d\tdur = %6.3fsec\n",
			(short)sfsrate(&hd),sfchans(&hd),
			(float)sfbsize(&st)/(sfsrate(&hd)*sfchans(&hd)*sfclass(&hd)));
		}

		/* Allocate buffers and execute */

		if(((inbuf = malloc(SF_BUFSIZE/chanfac)) == NULL) || 
		    ((outbuf = malloc(SF_BUFSIZE)) == NULL)) {
			fprintf(stderr,"Bad call to malloc.\n");
			exit(1);
		}
		bytes = sfbsize(&st);

		while(bytes>0) {
			bufnum = ((bytes>SF_BUFSIZE/chanfac)? SF_BUFSIZE/chanfac : bytes) ;

			if((numbytes = read(sfd,inbuf,bufnum))<0) {
				fprintf(stderr,"Bad read from source file\n");
				exit(1);
			}
			sampcount = numbytes/sfclass(&hd)*chanfac;
			outbytes = sampcount * SF_SHORT;  
			if(sfclass(&hd) == SF_FLOAT) {	/* floating point file in */
				register float *floatin = (float *) inbuf;
				register short *shortout = (short *) outbuf, *sbufend; 
				sbufend = (short *) outbuf + sampcount;
				if(chanfac == 1)
					while(shortout < sbufend)
						*shortout++ = (short)*floatin++;
				else if(chanfac == 2 && !stereo)
					while(shortout < sbufend) {
						*shortout++ = (short)*floatin++;
						*shortout++ = 0;
					}
				else if(chanfac == 2 && stereo)
					while(shortout < sbufend) {
						*shortout++ = (short)*floatin++;
						*shortout++ = (short)*floatin++;
						*shortout++ = 0;
						*shortout++ = 0;
					}
				else if(chanfac == 4)
					while(shortout < sbufend) {
						*shortout++ = (short)*floatin++;
						*shortout++ = 0;
						*shortout++ = 0;
						*shortout++ = 0;
					}
			}
			else {   /* integer file input */

				register short *shortin = (short *) inbuf;
				register short *shortout = (short *) outbuf, *sbufend; 
				sbufend = (short *) outbuf + sampcount;
				if(chanfac == 1)
					outbuf = inbuf;
				else if(chanfac == 2 && !stereo)
					while(shortout < sbufend) {
						*shortout++ = *shortin++;
						*shortout++ = 0;
					}
				else if(chanfac == 2 && stereo)
					while(shortout < sbufend) {
						*shortout++ = *shortin++;
						*shortout++ = *shortin++;
						*shortout++ = 0;
						*shortout++ = 0;
					}
				else if(chanfac == 4)
					while(shortout < sbufend) {
						*shortout++ = *shortin++;
						*shortout++ = 0;
						*shortout++ = 0;
						*shortout++ = 0;
					}
			}
			if(write(sfd2,outbuf,outbytes) != outbytes) {
				fprintf(stderr,"Bad write to output file \n");
				exit(1);
			}
			bytes -= numbytes;
		}
		close(sfd);
	}
	/* Report new file stats */
	if(verbose) {
		fprintf(stderr,"\nOutput: %s\t",newname);
		fprintf(stderr,"SR= %d",(short)srate);
		fprintf(stderr,"\tnchans= %d\tdur = %6.3f\n",maxchans,dur);
	}
	close(sfd2);
	exit(error);
}
usage(exitcode)
	int exitcode;
{
	fprintf(stderr,"%s%s%s%s\n",
	"usage: catsf [options] filenames \n",
	"\t-v\tverbose\n",
	"\t-fname\toutput soundfile: name\n",
	"\t-Rn\toutput sample rate = n\n");
	exit(exitcode);
}
