.TL 
INTRODUCTION TO CARL PROGRAMMING
.AB
This document describes general CARL program behavior and
standards as seen
from the perspective of a program user.
.AE
.AU
Dr. Gareth Loy
.AI
Computer Audio Research Laboratory,
Center for Music Experiment,
University of California, San Diego,
La Jolla, CA 92093.
.NH 1
INTRODUCTION
.PP
There is a consistency in the the design of programs at CARL.
While the fidelity to the design standard
varies from program to program in practice, in principle
the programs were written within the framework of general guidelines
described here.  
This document gives clues as to how to
expect CARL programs to behave however, there are
no warranties expressed or implied; 
.I 
caveat emptor.
.R
.NH 2
THE UNIX FOUNDATION FOR CARL SOFTWARE
.PP
The basis of the CARL software standard is the 
.UX
operating system 
and the C 
programming language which we feel
provide tools especially suited for audio research.
When placed on a continuum,
the C programming language lies in the middle level between 
"low level" languages, 
suitable for operating systems design and computation-bound programming
applications, and "high level" languages, which 
provide many automatic features which ease the task of programming.
As such, C is ideally suited for signal processing tasks, 
many of which require a great deal of computational power.
All CARL programs are written
in C to be run under UNIX.  Since UNIX
itself is written in C, this provides a high degree of
coherency between operating
system and the CARL applications programs.
.NH 2
PROGRAMS AS FILTERS
.PP
UNIX supplies the idea of a program as a
.I 
modular filter.
.R
A UNIX program is a
.I filter
in the sense that
a program, like a filter, reads input,
performs some transformation on the data
then writes it out.  There are other notions about how to model what a
program is and does, but this is a very fruitful one for signal
processing tasks.
.PP
UNIX programs are
.I modular
in the sense that each one is supposed to perform some basic operation
for which it is named.  These programs can then be 
plugged together to perform higher level tasks.  
.PP
This modularity is
very well modeled by the typical analog synthesizer module or electronic
test instrument.  Most such modules
have an input and output,
with various manual or electronic controls and readouts.
In UNIX, a program reads its primary input from the
.I 
standard input
.R
and writes it on its
.I 
standard output.
.R
The controls are called
.I flags.
They can be thought of as jacks on a module's front panel which can
be connected by patch chords;  any module's standard output 
can be attached to another's standard input (but not directly to its own).
On a synthesizer, an oscillator can be patched to a voltage controlled
amplifier (VCA).  
In the parlance of UNIX, two programs patched together
are said to be connected via a
.I pipe.
(This gives it more the flavor of plumbing than electronics, but gets the
point across).  
In UNIX, if two programs are named
.B osc
and
.B vco,
we can pipe them together with a command line like the following:
.DS
% osc | vco
.DE
The modules have no concern about where their input and
output comes and goes. But the input must behave in expected ways, of course.
If the synthesizer output from the VCA were to be recorded, the VCA's
output would be sent to a tape recorder.  In UNIX, data is saved on
disk by
.I redirecting
the standard output to a data file on the disk.
Programs are also stored on the disk as program files.
Since both programs and data are stored alike on disk, there must be a way
of disambiguating sending data to another program 
.I vs.
sending it to a file on the disk.
UNIX uses the symbols
.B '>'
and
.B '<'
instead of the 
.B '|'
symbol to signify that the next object on the command line is a data file
rather than a program file.  For instance, the command
.DS
% osc | vca > saveit
.DE
will interpret 
.B osc 
and 
.B vca 
as programs, since they are connected by a 
.B pipe.
UNIX will
.I redirect 
the standard output of 
.B vca
to the data file
.B saveit 
because the 
.B '>'
symbol indicates that that is to be a data file.
If we had previously saved output from the
.B osc
program into a file named
.B saveosc 
with a command of the form
.DS
% osc > saveosc
.DE
we could 
.I redirect
the standard input of the
.B vca
program to read this file with the command
.DS
% vca < saveosc > savevca
.DE
and the result would be saved in
.B savevca.
.PP
When you do not redirect program output, the standard output is
redirected by default to your terminal.
.PP
We can now fill in some details of our example.  
It would be sensible for us to be able to change the frequency, waveform,
and phase of our 
.B osc
program.
This could be implemented in any of a number of ways.  One 
useful capability would be to 
interpret 
the standard input of
.B osc
as a
control signal that adjusts
the rate of radian velocity of the waveform being generated, producing FM.  
Then we could do this:
.DS
% osc | osc
.DE
to create a simple FM spectrum.
.PP
Another method, more suitable for setting fixed values,
would be to make 
.B osc
know about
.I flags
which would set values in
.B osc.  
For instance, we could make 
.B osc
accept a command like the following:
.DS
% osc \-f440
.DE
to set the frequency to 440 Hz.  The "\-f" part is the 
.I flag,
and the "440"
part is called the
.I option.
Flags always begin with a '\-' character.
Flags can come with and without options.  
Some programs have flags, some
don't.  Some programs expect the option to be concatenated to the flag,
some require a space in between.  (Concatenating the flag and option
is the method to be preferred.  In all cases, CARL programs concatenate
options to flags, however, many UNIX programs do not follow this 
convention.)
.PP
We could supply the name of a file to the program which would
contain instructions or a function of some kind which would tell it what
to do.  This file would not be presented on its standard input, but on
the command line, after all flags were given.  For instance,
notice that the
.B vca
program
gets the signal to be amplified from its standard input.  But 
voltage controlled amplifiers must also have an input for a function of
time describing the amplitude contour to use to shape the signal.
The place in a UNIX program where such a function would be supplied is 
as an auxiliary file.  For instance, the command
.DS
% osc \-f440 | vca envelope > saveit
.DE
will pass the name of the file
.B envelope
to the
.B vca
program.
.B vca
can then open the file and read its contents itself, and if it is suitable,
use it to control the gain of the
signal on its standard input.  
.PP
Finally, 
a program
can have both flags and filenames, a standard input and output all together.
For instance, the 
.B \-g 
flag in the command 
.DS
% osc \-f440 | vca \-g.5 envelope > saveit
.DE
could be interpreted by
.B vca
as a gain offset added to that supplied by the file
.B envelope.
.NH 1
CARL PROGRAM CONTEXT
.PP
Because programs in UNIX can communicate with pipes via their standard
output and input, CARL programs are designed to address a single task
(or small subset of related tasks) and yet
to take advantage of the modularity
of UNIX to achieve a considerable richness of application.
The benefits of modularity are well known.
When a capability is not present, it can be
invented quickly and easily as a stand-alone program, 
instead of having to modify a large, complex program.
Users can learn one simple operation at a time much more easily than
they can fathom a complex program with myriad features.
Programs can be more easily debugged.  Since it seems that bugs grow 
geometrically with program size, small programs come up more quickly and
work more reliably.
.NH 2
PROGRAM I/O CONVENTIONS
.PP
The CARL signal processing programs pass digital signals from one
to the next on their standard inputs and outputs as two's compliment binary
floating point numbers.  When the standard output is connected to a
terminal, the program causes the
numbers to be printed in text format, sometimes called ``arabic'' or
ASCII in CARL documentation.
But when a program is
connected to a file or pipe, binary floating point numbers are written.
These latter are called 
.I floatsams.
Usually, acoustic waveform signals are in the 
.I
signed unit interval,
.R
the interval of [\-1.0,1.0].
.PP
An alternate data format is
.I shortsams,
which are 16-bit two's compliment binary integers.  This format is read
by digital to analog converters, and written by analog to digital converters.
.NH 2
COMMAND LINE FORMAT
.PP
The general command line format of UNIX programs is a string of
blank-separated 
.I arguments, 
possibly separated into groups
by file 
.I redirection 
or 
.I pipe 
symbols,
where the first argument of each group is the name of a command to
be executed, and the remaining arguments up to the next 
file redirection or pipe symbol are handed to the named program as
configuration information.  
There are three kinds of
argument. 
The first argument must be the
name of an 
.I
executable program.
.R
Any
.I flags 
must come next and names of 
.I files
come last.
.PP
The canonical command line format of CARL programs is as follows:
.DS
% command_name [flags] [files] < input > output
.DE
The
.I input
and
.I output
are often required to be
.I floatsams.
Input and output redirection can be pipes as well as files, of course.
.NH 3
FLAGS
.PP
Flags
have the purpose of communicating all information 
other than the names of files to the program being invoked. 
Flags have the format
.I \-fO
that is, a dash, followed by a single letter,
followed (optionally, depending on the interpretation of the flag) by a
further component.   CARL programs distinguish between upper and lower
case flags.
.PP
The
.I O
part, called the "option",
depends entirely on the meaning of the flag as to what it may be or
whether it should be there at all.
If it is present, the
.I O
part must be concatenated to the 
.I \-f
part.  
(No intervening space may occur between a flag and its option.
.NH 3
EXPRESSIONS AND OPTIONS IN FLAGS 
.PP 
Flags are often used to set numeric values, such as sampling
rate, frequency, etc.  Most CARL programs allow the values 
in the option part of flags (and occasionally elsewhere) to be
expressions. 
The expression evaluator in this case usually accepts 
expressions in a variant of
.I cmusic(1carl)
expression notation.
We can use the problem of specifying sampling rates to programs as
an example.
By default, most CARL programs which require a sampling rate
will use 16KHz as
the basis of their computations.  In general, for all such programs, a
flag of the form
.I \-RN
will be recognized to set the sampling rate.  (The flag character,
.I R
is almost universal for this usage).
The
.I N
option
may be an expression in
.I cmusic
notation. 
For instance,
.I \-R48K
sets the sampling rate to 49152 samples per second.
Alternately,
.I 
\-R"1024*48"
.R
says the same thing.  Note the quotation marks around the expression.
They are required because the shell, which evaluates the command line,
treats the characters '*', and '(' ')' in ways incompatable with
their usage in arithmetic expressions.  This is unfortunate, but the
simple solution is to enclose any expression in double quotes that is
likely to offend the shell.
.PP
Wherever the determining of one variable set by a flag depends on another
flag, the CARL program will evaluate them in the right order to get the
dependencies straight.  For instance, where frequency and sampling rate
can both be set by flags, the flag for sampling rate will be interpreted
first.  The program will then evaluate the frequency.
The user does not need to be concerned with the order of
flags with dependencies.
.PP
CARL programs do their best to do something reasonable in the simple case.
For instance, when the 
.I wave 
and 
.I show 
programs are piped together,
.DS
% wave | show
.DE
a crude plot of a sine wave is displayed. 
Both programs are replete with flags to alter their behavior to handle
variations to the standard but do the "right thing" by default.
.NH 1
DATA HEADERS
.PP
All CARL programs that are a source of sample streams are (or should be)
set up to write a data header at the beginning of the sample stream.
This header contains information about the data that would otherwise
have to be explicitly passed by the programmer to each program of a
sequence by hand.  The most direct example is the command
.DS
% cmusic score_file | sndout sound_file
.DE
The sampling rate, number of channels, and some other details of the
cmusic score are passed in the header from cmusic to sndout.  If this
were not done, the user would be required to specify these parameters
as flags to sndout.  If for some reason it is desired to override the
header, any flags that are given to sndout override the properties
given in the header.
.NH 1
DOCUMENTATION AND HELP
.PP
There are several possible sources for help and documentation given below.
Documentation divides into two parts, that for program users and that for
program developers and maintenance.
.NH 2
HELP PROGRAM
.PP
The
.I help
program will print brief, practical guides to using a program, aimed at
getting some simple, but useful, behavior out of a program.
For instance,
.DS
% help wave
.DE
prints a summary of how to use the
.I wave
program.
.NH 2
MAN
.PP
All CARL programs are either documented with standard 
.I 
UNIX Programmers Manual 
.R
(UPM)
page entries.  
Stand-alone programs will be in Volume 1, with
a subsection heading of
.I 1carl.
This documentation is available on-line at CARL via the
.B man(1)
command. CARL publishes a CARL suppliment to the UPM,
called the \fICARL Startup Kit\fP.
CARL Libraries are documented in volume 3 (3carl).
Manual page entries are a more formal description of the method of
using a program.
.NH 2
USAGE STATEMENTS
.PP
All CARL programs have brief messages describing a
synopsis of their actions, command line formats, and flags.  This usage
statement, as it's called, can usually be evoked in two ways:
.IP
just naming the program on the command line without giving any other
arguments or file redirection, or
.IP
giving a 
.I \-h 
(for "help") flag.
.NH 2
TUTORIALS
.PP
Tutorials exist for many CARL programs such
as 
.I cmusic,
.I csound
and friends.
At CARL, these live in the directory /carl/src/carl/doc, and are 
generally in
.I nroff(1)
format.
.NH 1
CAVEAT
.PP
Not all CARL programs adhere with great fidelity to these standards.
However, the exceptions do not overwhelm the rule.
