.TL 
COMPUTER AUDIO RESEARCH LABORATORY SOFTWARE WRITERS GUIDE
.AU
Dr. Gareth Loy, Software Coordinator
.AI
Computer Audio Research Laboratory,
Center for Music Experiment,
University of California, San Diego,
La Jolla, CA 92093.
.AB
This document gives guidance on implementation,
documentation and administration of CARL software.
.AE
.NH 1
INTRODUCTION
.PP
As is described in 
.[ [
moore carl
.]]
the Computer Audio Research Laboratory (CARL)
standard for programming is based around the usage of the
.UX
operating system 
.[ [
unixtss
.]]
and
the C
programming language
.[ [
kernighan system programming language
.]].
UNIX standards are followed in CARL programming where possible, with
only a few differences and augmentations.
.NH 1
OVERVIEW
.PP
The large scale
issues to consider in designing software for a UNIX environment
include the user interface,  
shared data types between programs, 
and with UNIX, coding standards, and documentation.  Each of the following
sections will attempt to provide specific guidance as to how an ideal
program should address these issues.  Of course there are situations where
following the 
letter of these guidelines would be inappropriate.  However, knowledge
of them will still aid in finding the most satisfactory implementation
within the spirit of the guidelines.
.PP
The guidelines stated here are for public programs.  Private programs,
(which are defined as having the executable files in a private directory)
are subject to no standards until they become public.
.NH 1
PROGRAM FILES AND DIRECTORIES
.PP
The guiding principles to the following subsections are as follows.
.IP \(bu
Programs and data bases
should be self contained to resist being broken through 
fragmentation of the required files.
.IP \(bu
Do not put programs or data in directories that are 
not carried across to new releases of UNIX
(i.e., they should not be put in standard UNIX directories).
.NH 2
PROGRAM NAMEING CONVENTIONS
.PP
There is often a naming
conflict between programs that perform similar
functions for different purposes.  Don't name a
program so that it co-opts an entire concept in programming.  For instance
don't name a program "compile", or "count".  
Good names are short, easy to type, and self-explanitory.
Name no program the same as any currently existing UNIX utility
or local program.
.PP
Some people like to 
distinguish directories from files by using case distinctions. 
Please don't.
It's awkward to shift back and forth when entering complicated
pathnames; instead, get used to telling them apart with ls -F.
.NH 2
SOURCE LANGUAGES
.PP
Wherever possible, use C.
This maintains the tight integration between CARL programs and UNIX,
which is written in C.  This also simplifies the task of program maintenance,
and makes the solutions to one programming problem immediately available
to another.
Exceptions to the use of
C are for such things as FORTRAN subroutines
supplied by an external source, such as the IEEE
\fIPrograms for Digital Signal Processing\fP, for example.
Avoid Pascal, FORTRAN, Basic and COBOL.
Assembly language programming is considered necromancy, and is to be
avoided at all costs.
.NH 2
DIRECTORIES FOR PROGRAM SOURCES
.PP
Ordinarily, sources for a program will be kept in 
a subdirectory of the author's home directory until it is published.
When published, its sources join the directory for other released 
CARL software (see SOFTWARE DISTRIBUTION, below).
If a program occupies several files, they should all be in the same
directory.  
Each program should exist in a separate directory, named
for the program, unless a group of programs forms a suite, where there
is one file per program.  
Where each program does not occupy more than one file,
multiple programs can be grouped by function into one directory.
For private software,
the convention is to have a directory, ~you/progs, with subdirectories
for sources.
.NH 2
DIRECTORIES FOR EXECUTABLE PROGRAMS
.PP
The directory /carl/new is the place for all new programs to be put during
their experimental phase of publication.  This directory has read/write
permission by everyone, and most CARL users have this directory in their
path or PATH variables.
The directory /carl/bin is reserved for released software.
Programs are 
promoted to /carl/bin when it seems to the CARL staff
that they have sufficiently matured.
The purpose of /carl/new directory is to shield users who may not want to work
with experimental versions of programs.  These users
simply remove /usr/new from their
.B path 
variables, or to have it searched after /carl/bin.
.NH 2
MAKE PROGRAM
.PP
Each program should be compiled with
.I make(1).
A standard template makefile exists which contains 
.I m4(1) 
macros for the names of important directories and libraries.
These macros are expanded by using the
.B mm(1carl)
command, which creates a Makefile with
correct paths for fetching
libraries and installing the program on the system.  Refer to the 
documentation for 
.B mm(1carl)
for details.
.NH 2
INCLUDE FILES
.PP
The directory /usr/include/carl is where published program
include files go.  This is typically used for libraries.
Include files should either
be in the program directory itself, or in one of the standard 
directories in /usr/include.
.PP
There are several standard include files in /usr/include/carl.
Here are some of the files:
.DS
carl.h - declarations for subroutines in libcarl(3carl)
cmusic.h - useful macros for cmusic scores
config.m4 - database for mm(1carl)
defaults.h - macros with system default parameters
paths.h - wired-in path names used by CARL programs
procom.h - declarations for the procom(3carl) data header library
sndio.h - declarations for the csound(3carl) file system
.DE
.NH 2
REQUIRED EXTERNAL PROGRAMS
.PP
Programs should be entirely self-contained where possible.  
Programs which execute other programs via exec(2) should make sure
that the executed program is not transient, and will not be
likely to be separated from the parent program.
Programs using wired-in pathnames should compile them by reference to
<carl/paths.h>.
.NH 2
REQUIRED EXTERNAL SUBROUTINES AND LIBRARIES
.PP
CARL libraries are all in /carl/lib.
Libraries of common CARL subroutines 
are kept in libcarl.a.
See the \fICARL Startup Kit\fP for manual pages for these
subroutines.
.NH 2
DATABASES
.PP
If a program maintains a database, it can go in any of a number of places.
If data is temporary, put it in /tmp.
If it is a queue, /usr/spool.  If it is a dictionary, in 
/carl/lib.
.NH 1
DATA TYPES
.PP
CARL signal processing programs operate on single precision binary floating
point sample data, called (by contraction, and to facilitate a mild pun) 
.B floatsams.  
Sample data in a signal
processing program is expected to be this format by default.
A standard set of routines is available for handling this
format.  See the manual page for
.B getfloat(3carl)
in the \fICARL Startup Kit\fP.
.PP
Programs that write sample data must be sensitive as to whether a terminal,
or file or pipe is connected to its output.  If it is a terminal, ASCII
data is written; if a file or pipe, floatsams are written.
The standard UNIX library routine
.B isatty()
(in
.B ttyname(3))
can be used for this.
.PP
Mass sound sample data are stored by the
sound file system, usually as short integers, called
.B shortsams.
.PP
Multiple channel sample files are stored in sample-interleaved (as opposed
to block-interleaved) form.
.PP
.NH 1
HEADERS
.PP
All CARL programs that read sample data must be able to read data headers.
These are described in
.B getfloat(3carl)
and 
.[ [
loy procom
.]]
Programs that write sample data should also write headers.  Standard properties
are given in /usr/include/carl/defaults.h.
.NH 1
COMMAND LINE FORMAT
.PP
The cannonical command line format is:
.DS
command_name [flags] [files or other arguments] < stdin > stdout
.DE
All configuration parameters are to be passed
.I via 
flags.
Flags have the format:
.DS
\-<character>[<value>]
.DE
where <value> is any string without blanks, (or double-quoted string
with blanks, where appropriate).
A subroutine used by almost all CARL programs to parse the command line
along these lines is 
.B crack(3carl).
Refer to its documentation.
.PP
All programs should respond to a \-h flag, which should print a synopsis
of program usage, showing the command line usage, and listing all flags.
It should be terse, and not try to explane how to run the program.  Use
the manual page or the help program for that.
.NH 1
DOCUMENTATION
.PP
Documentation for programs is divided into several functional levels, 
depending on who is getting information about what.  It can be divided
into four main divisions: 1) for users, 2) for program maintenance,
3) on line, 4) hardcopy.  All hardcopy documentation should have a
comment at the top with a sample command line to format the document
on the relevant printer.
.NH 2
README FILES
.PP
A README file should exist in each program source directory giving 
installation instructions, and any additional orientation needed for
program maintenance.
.NH 2
SOURCE CODE COMMENTING
.PP
Naturally, comments should be liberally sprinkled throughout a program.
At a minimum, an extended comment should appear at the head of the
main() subroutine describing the general operation.  Important subroutines
should also have comments.  Comment individual lines of code where
the thrust of the context would not be clear, as for instance where
there are complex conditionals, or abstruse equations.
.NH 2
WIRED-IN DOCUMENTATION
.PP
As stated above, all programs should respond to a -h flag for information.
This should include the command line syntax, the flags, and a one-line
description of their function and the range of their variables, if any.
If the -h flag is given, execution always stops as soon as that flag is
seen, and the program returns an exit status of 0 (i.e., asking for
help is not an error).  The same usage statement, preceeded by a more
specific diagnostic, can be given for syntax errors, illegal flags,
etc., but here the exit status should be nonzero, usually 1.
See the appendix for an example program demonstrating this.
.NH 2
HELP DOCUMENTATION
.PP
The 
.B help(1carl)
program provides tutorial information on selected programs and other aspects
of the system.  
The
.B help(1carl)
database is a directory tree grouped into main branches for signal processing
analysis, synthesis, composing, and many other topics.  Help files are
individual text files.  For information, refer to
.B help(1carl).
.NH 2
MAN DOCUMENTATION
.PP
Installed CARL manual pages are kept in /carl/man/manc.
Now that 
.B man(1)
knows how to look elsewhere besides /usr/man for manual pages, each
user must have a shell environment variable:
.DS
MANPATH=/usr/man:/carl/man
.DE
in their .login file in order to reference CARL manual pages.
Because of past limitations of 
.B man(1),
all sections of the \fICARL Startup Kit\fP appear in that one directory.
Someday, this may be fixed.
.NH 2
TUTORIALS
.PP
Tutorials are simplified reports on the operating theory of a program.
For complicated programs, tutorials are a must.  Tutorials for CARL
programs are in 
.B troff(1)
format.  For distributed programs, the source tutorial should reside
in the distribution area, see below.
Formatted versions, where appropriate, also
appear in the 
.B help(1carl)
database.
.NH 2
OTHER DOCUMENTATION
.PP
If a program utilizes knowledge that is in print elsewhere, this fact
should be noted wherever appropriate, usually in the tutorial, and the
manual page.
.NH 2
CARL PUBLISHED DOCUMENTATION
.PP
CARL occasionally publishes memoranda and reports on technical subjects
relating to current research topics.  It may be that your documentation
should be published as a technical memorandum.
.NH 2
CARL STARTUP KIT
.PP
CARL publishes a
.I
Startup Kit
.R
for beginning users and students.  It contains introductory articles
on the main CARL programs, plus manual pages for released software.
Tutorial documentation should be submitted for inclusion there.
.NH 1
CARL SOFTWARE DISTRIBUTION
.PP
All released software generated at CARL is available for distribution.
CARL provides this software for the media and administrative processing
cost as a public service.
.PP
Software to be submitted to this distribution must follow specifications
given in this document wherever possible.  Refer questions to the
software staff.
.PP
The root of the CARL Software Distribution is /carl/src/carl 
on the machine sdcarl.ucsd.edu.
For a further discussion of software installation and distribution,
refer to the companion paper, 
.I
How to Add New Programs to the CARL Software Distribution.
.R
.SH
REFERENCES
.[ [
$LIST$
.]]
.SH
APPENDIX 2
.PP
The following program demonstrates a simple usage of many of the
points given above.
.DS L
.ps 12
.nr PS 12
.vs 14
.nr VS 14
.ft C
/*
 * fibonacci - return Ith Fibonacci number
 * fibonacci returns the Ith element of either the Fibonacci series,
 * or any other first order summation series whose first two terms
 * are given with -aN and -bN.  One element is returned unless -nN appears,
 * in which case that number of elements from the Ith is returned.
 */

#include <stdio.h>
#include <carl/carl.h>

extern long summation();

main(argc, argv)
	char **argv;
{
	long a = 1, b = 1, i, j, N = 1;
	float x;
	char ch;

	while ((ch = crack(argc, argv, "i|a|b|n|h", 0)) != NULL) {
		switch (ch) {
			case 'i':	
				i = expr(arg_option); 
				break;
			case 'a':
				a = expr(arg_option); 
				break;
			case 'b':
				b = expr(arg_option); 
				break;
			case 'n':
				N = expr(arg_option);
				break;
			case 'h':
				usage(0);
			default:
				usage(1);
		}
		if (exprerr) {
			fprintf(stderr, "fibonacci: error in expression: %s\\\\n",
				arg_option);
			usage(1);
		}
	}

	if (isatty(1)) {
		for (j = 0; j < N; j++)
			printf("%d\\\\n", summation(i++, a, b));
	} else {
		for (j = 0; j < N; j++) {
			x = summation(i++, a, b);
			putfloat(&x);
		}
		flushfloat();
	}

	exit(0);
}

long
summation(n, a, b)
	long n, a, b;
{
	if (n == 0)
		return(a);
	else if (n == 1)
		return(b);
	else
		return(summation(n - 1, a, b) + summation(n - 2, a, b));
}

usage(ex)
{
	fprintf(stderr, "%s%s%s%s%s%s",
		"usage: fibonacci [flags] > floatsam(s)\\\\n",
		"flags:\\\\t(defaults)\\\\n",
		"\\\\t-iI\\\\treturn series value at index I (1)\\\\n",
		"\\\\t-aN\\\\tset series first seed to N (1)\\\\n",
		"\\\\t-bN\\\\tset series second seed to N (1)\\\\n",
		"\\\\t-nN\\\\treturn N values of the series (1)\\\\n"
	);
	exit(ex);
}
.DE
