#include "JOnOffSequencer.h"
#include "JHandler.h"
#include "JEvent.h"
#include "JEffectNode.h"
#include "JPlayer.h"

JOnOffSequencer::JOnOffSequencer(const JEvent *onEvent,
				 JPlayer * handler)
  
  :   _event(onEvent),
      _onEvent(onEvent),
      _beat(JBeat::endOfTime()),
      _handler(handler)
{
  const JEffectNode *noteOnEvent  = _event->seekEffect(NOTE_EFFECT);
  if ( noteOnEvent == 0 ) return;
  const JEffectNode *noteOffEvent  = noteOnEvent->right();
  assert( noteOffEvent != 0 );
  _offEvent = noteOffEvent->event();
}

JBeat 
JOnOffSequencer::nextBeat()
{
  return _beat;
}



JBeat
JOnOffSequencer::execute()
{
  assert( _event != 0);

  // TODO loop for _time events

  ((JHandler  <JEvent *,void> *)_handler)->handle((JEvent *)_event);

  if (_event != _offEvent) {
    _event = _offEvent;
    _beat  = _event->beat();
  }  else   {
    _beat=JBeat::endOfTime();
  }
  return _beat ;
} 


JBeat
JOnOffSequencer::gotoBeat(const JBeat &when)
{
  
  if (when  <= _onEvent->beat()) {
      _beat = _onEvent->beat();
      _event= _onEvent;
  }  else  {
    _beat=JBeat::endOfTime();
    _event=0;
  }

  return _beat;
}







