#include "JMidiInEvent.h"
#include "assert.h"
#include <ostream.h>


ostream & operator <<(ostream &out,const JMidiInEvent &event)
{
  event.debugOut(out);
  return out;
}


// JMidiInEvent::JMidiInEvent(const JMidiInEvent &cloneMe)
// {
  

// }

void
JMidiInEvent::debugOut(ostream &out) const
{
  switch(type().type())
    {
    case JMidiInType::NOTEON: 
      out << " NoteOn";
      out << " Pitch: " << (int)pitch();
      out << " Vel: "  << (int)velocity();
      break;

    case JMidiInType::NOTEOFF:
      out << " NoteOff";
      out << " Pitch: " << (int)pitch();
      break;

    case JMidiInType::CONTROLLER:
      out << " Controller:" << (int)controller();
      out << " Value: " << (int)value();
      break;
      
    case JMidiInType::PITCHBEND:
      out << " PitchBend:" << (int)pitchBend();
      break;
      
    case JMidiInType::PROGRAM:
      out << " Program:" << (int)program();
      break;
      
    case JMidiInType::PRESSURE:
      out << " Pressure:" << (int)value();
      break;

    default:
      out << " UNKNOWN:" << (int)value();
    }
}



int
JMidiInEvent::value() const
{
  switch(type().type())
    {
    case JMidiInType::NOTEON: 
      return velocity();
      break;

    case JMidiInType::NOTEOFF:
      return 0;
      break;

    case JMidiInType::CONTROLLER:
      return controllerValue();
      break;
      
    case JMidiInType::PITCHBEND:
      return pitchBend();
      break;
      
    case JMidiInType::PROGRAM:
      return program();
      break;
      
    case JMidiInType::PRESSURE:
      return pressure();
      break;

    default:
      assert(0);
      return 0;
    }
}

int
JMidiInEvent::index() const
{
  switch(type().type())
    {
    case JMidiInType::NOTEON: 
      return pitch();
      break;

    case JMidiInType::NOTEOFF:
      return pitch();
      break;

    case JMidiInType::CONTROLLER:
      return controller();
      break;
      
    default:
      return 0;
    }
}



