#ifndef _JLRRep_H
#define _JLRRep_H

#include "JBeat.h"

//#include "JLR.h"


class JLRRep // :public JLR
{
public:
  JLRRep(JBeat left,JBeat right):_left(left),_right(right){;}

  JBeat left() const { return _left; } 
  JBeat right() const { return _right; }

  void  setLeft(JBeat b) { _left=b; }
  void  setRight(JBeat b) { _right=b; }

  bool contains(JBeat b) const { return (b < _right && b >= _left); }
  bool empty() const { return ( _right < _left ); }

private:
  JBeat _left;
  JBeat _right;
};


inline
JLRRep intersect(const JLRRep a,const JLRRep b)
{

  if (a.right() < b.left()) 
    return JLRRep(JBeat::endOfTime(),JBeat::startOfTime());

  if (b.right() < a.left()) 
    return JLRRep(JBeat::endOfTime(),JBeat::startOfTime());

  if (a.left() > b.left()) {
    if (a.right() > b.right())
      return JLRRep(a.left(),b.right());
    else
      return JLRRep(a.left(),a.right());
  } else {
    if (a.right() > b.right())
      return JLRRep(b.left(),b.right());
    else
      return JLRRep(b.left(),a.right());
  }

}

#endif


