#include "assert.h"
#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>
#include <sys/ioctl.h>
#include <fcntl.h>

extern "C" {
#include <linux/soundcard.h>
#include <linux/awe_voice.h>
#include <awe/util.h>
#include <awe/sffile.h>
}

#include "dirview.h"
#include "QJSBKPatchItem.h"
#include "QJSBKItem.h"

#include <qdir.h>
#include <qfile.h>
#include <qfileinf.h>


QJSBKPatchItem::QJSBKPatchItem( QJSBKItem * parent, SFPresetHdr *preset)
    : QListViewItem( parent ), _preset(preset)
{

}

void QJSBKPatchItem::setOpen( bool  )
{
  
}

void QJSBKPatchItem::activate()
{
  printf("%d %d %s \n",_preset->bank,		
	 _preset->preset,			
	 _preset->hdr.name);	
}

void QJSBKPatchItem::setup()
{
    setExpandable( FALSE );
    QListViewItem::setup();
}


QString QJSBKPatchItem::fullName()
{
    QString s;
//    printf("%d %d %s",_preset->bank,		
//		      _preset->preset,			
//	      _preset->hdr.name);	
    return s;
}


const char * QJSBKPatchItem::text( int column ) const
{
    static QString s;

    if (column == 0 ) {
        s.sprintf("%d %d %s",_preset->bank,		
		     	     _preset->preset,
         		     _preset->hdr.name);	
   } else
       s.sprintf("");		

   return s;	
}
