#include "QJPiano.h"
#include "Piano.h"
#include "QJKeyHandler.h"
#include "QJIntToMidiIn.h"
#include "QJVoiceWidget.h"
#include "jam/JVoice.h"
#include "jam/JFocus.h"
#include "jam/JContext.h"

QJPiano::QJPiano(JContext *context):Piano(6,24,0,"piano"),_voice(0)
{
  // object to map the piano signals to a midiIn subject
  _midiIn= new QJIntToMidiIn;

  // create an object to catch the key hits to be mapped onto
  // the virtual keyboard
  _kh = new QJKeyHandler;

  // use this to catch events in the paino window and voice widget
  installEventFilter(_kh);

//   QJVoiceWidget * voiceWidget = new QJVoiceWidget(voice);
//   voiceWidget->show();
//   voiceWidget->installEventFilter(_kh);

  resize(840,100);

  connect(_kh,SIGNAL(noteOn(int)),SLOT(Down(int)));
  connect(_kh,SIGNAL(noteOff(int)),SLOT(Up(int)));

  _midiIn->connect(_kh,SIGNAL(noteOn(int)),SLOT(noteOn(int)));
  _midiIn->connect(_kh,SIGNAL(noteOff(int)),SLOT(noteOff(int)));
  _midiIn->connect(this,SIGNAL(noteOn(int)),SLOT(noteOn(int)));
  _midiIn->connect(this,SIGNAL(noteOff(int)),SLOT(noteOff(int)));

  handle(context->focus());

}


void
QJPiano::handle(const JFocus *focus)
{
  if (focus->voice() != _voice) {
    if ( _voice != 0 ) _midiIn->detach(_voice);
    _voice = focus->voice();
    // connect the midiIN to a voice
    if (_voice != 0) _midiIn->attach(_voice);
  }

}

QJPiano::~QJPiano()
{

  delete _midiIn;
  delete _kh;
  //TODO delete stuff

}



