#ifndef _QJMainWidget_H
#define _QJMainWidget_H


#include <qdict.h>

/*!
  \class QJMainWidget QJMainWidget.h
  \brief Top level widget

*/

#include <qmainwindow.h>
#include <qmenubar.h>

class QJDurationWidget;
class QPushButton;
class QFrame;
class QJScoreWidget;
class QJTransportWidget;
class QJCompositionView;
class JContext;
class QJCommand;


class QJMainWidget : public QMainWindow
{
  Q_OBJECT
public:
  QJMainWidget(JContext *,
	       QWidget *parent=0, 
	       const char *name=0 );

  virtual ~QJMainWidget();


public:
  void plugin(const char *menuName,const char *cmdName,
	      QJCommand *,int accel=0);

private:

  QDict<QPopupMenu> *    _menuLookup;

  QJCompositionView  *   _trackWidget;

  QJScoreWidget *        _scoreWidget;            /// The score. 
  QJDurationWidget *     _durationWdgt;          

  QJTransportWidget    * _playWidget;
 
};


#endif 


