#include <qapp.h>
#include <qpainter.h>
#include <qwidget.h>
#include <qpaintd.h>
#include <qpen.h>


#include "QJDrawComponents.h"
#include "QJDraw.h"
#include "QJPixDraw.h"
#include "QJListDraw.h"
#include "assert.h"

#include "rep/JBeat.h"

QJDrawComponents * QJDrawComponents::_the=0;
int QJDrawComponents::_size=32;


QJDrawComponents *
QJDrawComponents::the()
{

  if (_the == 0) _the=new QJDrawComponents();
  return _the;

}


QJDrawComponents::QJDrawComponents()
{

  assert(_the==0);
  _the=this;

  _pa=new QPainter();
  QPen pe;

  pe.setWidth((_size/10));
  pe.setColor(color1);


  //Basic Units, Body
#include "bitmaps/score/note_bodyempty.xbm"
  _components[BODY]=new QJPixDraw(note_bodyempty_width,
				  note_bodyempty_height,
				  note_bodyempty_bits,TRUE);


#include "bitmaps/score/note_bodyfilled.xbm"
  _components[FILLEDBODY]=new QJPixDraw(note_bodyfilled_width,
					note_bodyfilled_height,
					note_bodyfilled_bits,TRUE);

  int bheight=_components[FILLEDBODY]->height();
  int spos=(bheight/2);
  int bwidth=_components[FILLEDBODY]->width();

  //tails
#include "bitmaps/score/tail_up_1.xbm"
#include "bitmaps/score/tail_up_2.xbm"
#include "bitmaps/score/tail_up_3.xbm"
#include "bitmaps/score/tail_up_4.xbm"
#include "bitmaps/score/tail_down_1.xbm"
#include "bitmaps/score/tail_down_2.xbm"
#include "bitmaps/score/tail_down_3.xbm"
#include "bitmaps/score/tail_down_4.xbm"

  _components[TAILU1]=new QJPixDraw(tail_up_1_width,tail_up_1_height,tail_up_1_bits,TRUE);
  _components[TAILU2]=new QJPixDraw(tail_up_2_width,tail_up_2_height,tail_up_2_bits,TRUE);
  _components[TAILU3]=new QJPixDraw(tail_up_3_width,tail_up_3_height,tail_up_3_bits,TRUE);
  _components[TAILU4]=new QJPixDraw(tail_up_4_width,tail_up_4_height,tail_up_4_bits,TRUE);
  _components[TAILD1]=new QJPixDraw(tail_down_1_width,tail_down_1_height,tail_down_1_bits,TRUE);
  _components[TAILD2]=new QJPixDraw(tail_down_2_width,tail_down_2_height,tail_down_2_bits,TRUE);      
  _components[TAILD3]=new QJPixDraw(tail_down_3_width,tail_down_3_height,tail_down_3_bits,TRUE);
  _components[TAILD4]=new QJPixDraw(tail_down_4_width,tail_down_4_height,tail_down_4_bits,TRUE);    
  
  //stick (drawn, not loaded)
  _components[STDSTICK]=new QJPixDraw(1,_size);
  _pa->begin(((QJPixDraw *)_components[STDSTICK])->bitmap());
  _pa->setPen(pe);
  _pa->drawLine(0,0,0,_size);
  _pa->end();
  
  //ladder for off stave notes.
  _components[LADDER]=new QJPixDraw((3*_size)/8,1);
  _pa->begin(((QJPixDraw *)_components[LADDER])->bitmap());
  _pa->setPen(pe);
  _pa->drawLine(0,0,(3*_size)/8,0);
  _pa->end();

  //Composite objects, Notes -------

  QJListDraw **listcomp=(QJListDraw **)_components;

  listcomp[SEMIB]=new QJListDraw(1);
  listcomp[SEMIB]->add(0,_components[BODY],-bwidth,-spos);
 
  listcomp[BEAMBODY]=new QJListDraw(1);
  listcomp[BEAMBODY]->add(0,_components[FILLEDBODY],0,-spos);

  listcomp[MINIMD]=new QJListDraw(2);
  listcomp[MINIMD]->add(0,_components[BODY],0,-spos);
  listcomp[MINIMD]->add(1,_components[STDSTICK],0,0);

  listcomp[CROTD]=new QJListDraw(2);
  listcomp[CROTD]->add(0,_components[FILLEDBODY],0,-spos);
  listcomp[CROTD]->add(1,_components[STDSTICK],0,0);
  debug("%d %d",listcomp[CROTD]->x(),listcomp[CROTD]->width());

  listcomp[QUAVD]=new QJListDraw(2);
  listcomp[QUAVD]->add(0,_components[CROTD],0,0);
  listcomp[QUAVD]->add(1,_components[TAILU1],0,_size-_components[TAILD1]->height());

  listcomp[SQUAVD]=new QJListDraw(2);
  listcomp[SQUAVD]->add(0,_components[CROTD],0,0);
  listcomp[SQUAVD]->add(1,_components[TAILU2],0,_size-_components[TAILD2]->height());

  listcomp[DSQUAVD]=new QJListDraw(2);
  listcomp[DSQUAVD]->add(0,_components[CROTD],0,0);
  listcomp[DSQUAVD]->add(1,_components[TAILU3],0,_size-_components[TAILD3]->height());

  listcomp[HDSQUAVD]=new QJListDraw(2);
  listcomp[HDSQUAVD]->add(0,_components[CROTD],0,0);
  listcomp[HDSQUAVD]->add(1,_components[TAILU4],0,_size-_components[TAILD4]->height());

  listcomp[MINIMU]=new QJListDraw(2);
  listcomp[MINIMU]->add(0,_components[BODY],-bwidth+2,-(spos));
  listcomp[MINIMU]->add(1,_components[STDSTICK],0,-_size);

  listcomp[CROTU]=new QJListDraw(2);
  listcomp[CROTU]->add(0,_components[FILLEDBODY], -bwidth+2,-(spos));
  listcomp[CROTU]->add(1,_components[STDSTICK],0,-_size);

  listcomp[QUAVU]=new QJListDraw(2);
  listcomp[QUAVU]->add(0,_components[CROTU],0,0);
  listcomp[QUAVU]->add(1,_components[TAILD1],0,-_size);

  listcomp[SQUAVU]=new QJListDraw(2); 
  listcomp[SQUAVU]->add(0,_components[CROTU],0,0);
  listcomp[SQUAVU]->add(1,_components[TAILD2],0,-_size);

  listcomp[DSQUAVU]=new QJListDraw(2);
  listcomp[DSQUAVU]->add(0,_components[CROTU],0,0);
  listcomp[DSQUAVU]->add(1,_components[TAILD3],0,-_size);

  listcomp[HDSQUAVU]=new QJListDraw(2);
  listcomp[HDSQUAVU]->add(0,_components[CROTU],0,0);
  listcomp[HDSQUAVU]->add(1,_components[TAILD4],0,-_size);








#include "bitmaps/score/rest_semibreve.xbm"
  _components[RESTSEMIB]=new QJListDraw(1);
  
  listcomp[RESTSEMIB]->add(0, new QJPixDraw(rest_semibreve_width,
					      rest_semibreve_height,
					      rest_semibreve_bits,TRUE),
			   -rest_semibreve_width/2,
			   -rest_semibreve_height/2);
   


#include "bitmaps/score/rest_minim.xbm"
    
  _components[RESTMINIM]=new QJListDraw(1);
  
  listcomp[RESTMINIM]->add(0,new QJPixDraw(rest_minim_width,
					    rest_minim_height,
					    rest_minim_bits,TRUE),
			    -rest_minim_width/2,
			    -rest_minim_height/2);

#include "bitmaps/score/rest_crotchet.xbm"
  _components[RESTCROT]=new QJListDraw(1);

  listcomp[RESTCROT]->add(0, new QJPixDraw(rest_crotchet_width,
					    rest_crotchet_height,
					    rest_crotchet_bits,TRUE),
			   -rest_crotchet_width/2,
			   -rest_crotchet_height/2);

#include "bitmaps/score/rest_quaver.xbm"
  _components[RESTQUAV]=new QJListDraw(1);

  listcomp[RESTQUAV]->add(0,  new QJPixDraw(rest_quaver_width,
					       rest_quaver_height,
					       rest_quaver_bits,TRUE),
			     -rest_quaver_width/2,
			     -rest_quaver_height/2);

#include "bitmaps/score/rest_semiquaver.xbm"
  _components[RESTSQUAV]=new QJListDraw(1);

  listcomp[RESTSQUAV]->add(0,  new QJPixDraw(rest_semiquaver_width,
					      rest_semiquaver_height,
					      rest_semiquaver_bits,TRUE),
			    -rest_semiquaver_width/2,
			    -rest_semiquaver_height/2);


#include "bitmaps/score/rest_demisemi.xbm"
  _components[RESTDSQUAV]=new QJListDraw(1);

  listcomp[RESTDSQUAV]->add(0,new QJPixDraw(rest_demisemi_width,
					     rest_demisemi_height,
					     rest_demisemi_bits,TRUE),
			     -rest_demisemi_width/2,
			     -rest_demisemi_height/2);


#include "bitmaps/score/rest_hemidemisemi.xbm"
  _components[RESTHDSQUAV]=new QJListDraw(1);

  listcomp[RESTHDSQUAV]->add(0,new QJPixDraw(rest_hemidemisemi_width,
						rest_hemidemisemi_height,
						rest_hemidemisemi_bits,TRUE),
				-rest_hemidemisemi_width/2,
				-rest_hemidemisemi_height/2);
  
  /// ACCIDENTALS
#include "bitmaps/score/notemod_sharp.xbm"
  _components[SHARP]=new QJPixDraw(notemod_sharp_width,
				   notemod_sharp_height,
				   notemod_sharp_bits,TRUE);



#include "bitmaps/score/notemod_flat.xbm"
  _components[FLAT]=new QJPixDraw(notemod_flat_width,
				  notemod_flat_height,
				  notemod_flat_bits,TRUE);

#include "bitmaps/score/notemod_natural.xbm"
  _components[NATURAL]=new QJPixDraw(notemod_natural_width,
				     notemod_natural_height,
				     notemod_natural_bits,TRUE);

  /// CLEF TYPES
#include "bitmaps/score/clef_bass.xbm"
  _components[BASS]=new QJPixDraw(clef_bass_width,
				    clef_bass_height,
				    clef_bass_bits,TRUE);


#include "bitmaps/score/clef_tenor.xbm"
  _components[TENOR]=new QJPixDraw(clef_tenor_width,
				    clef_tenor_height,
				    clef_tenor_bits,TRUE);



#include "bitmaps/score/clef_treble.xbm"
  _components[TREBLE]=new QJPixDraw(clef_treble_width,
				    clef_treble_height,
				    clef_treble_bits,TRUE);

#include "bitmaps/score/clef_alto.xbm"
  _components[ALTO]=new QJPixDraw(clef_alto_width,
				  clef_alto_height,
				  clef_alto_bits,TRUE);

#include "bitmaps/score/cursor.xbm"
  _components[CURSOR]=new QJListDraw(1);
  
  listcomp[CURSOR]->add(0, new QJPixDraw(cursor_width,
					 cursor_height,
					 (char *)cursor_bits,TRUE),
			-cursor_width/2,
			-cursor_height/2);
}

const QJDraw *
QJDrawComponents::component(Enum e) const
{
  return(_components[e]);
}



const QJDraw *
QJDrawComponents::note(const JDuration &tm,JNoteStyle flags) const
{
  if (flags&BEAMED){
    return _components[BEAMBODY];
  }
  else{
    if (flags&DOWN){
      if (tm==JDuration(0,1,16)) return _components[HDSQUAVD];
      if (tm==JDuration(0,1,8)) return _components[DSQUAVD];
      if (tm==JDuration(0,1,4)) return _components[SQUAVD];
      if (tm==JDuration(0,1,2)) return _components[QUAVD];
      if (tm==JDuration(1)) return _components[CROTD];
      if (tm==JDuration(2)) return _components[MINIMD];
      if (tm==JDuration(4)) return _components[SEMIB];
    }
    else{
      if (tm==JDuration(0,1,16)) return _components[HDSQUAVU];
      if (tm==JDuration(0,1,8)) return _components[DSQUAVU];
      if (tm==JDuration(0,1,4)) return _components[SQUAVU];
      if (tm==JDuration(0,1,2)) return _components[QUAVU];
      if (tm==JDuration(1)) return _components[CROTU];
      if (tm==JDuration(2)) return _components[MINIMU];
      if (tm==JDuration(4)) return _components[SEMIB];
    }
  }
  debug ("Pass me Durations I can resolve please!");
  return _components[STDSTICK];
}


const QJDraw *
QJDrawComponents::rest(const JDuration &tm) const
{

  if (tm==JDuration(0,1,16)) return _components[RESTHDSQUAV];
  if (tm==JDuration(0,1,8)) return _components[RESTDSQUAV];
  if (tm==JDuration(0,1,4)) return _components[RESTSQUAV];
  if (tm==JDuration(0,1,2)) return _components[RESTQUAV];
  if (tm==JDuration(1)) return _components[RESTCROT];
  if (tm==JDuration(2)) return _components[RESTMINIM];
  if (tm==JDuration(4)) return _components[RESTSEMIB];

  debug ("Pass me rest I can resolve please!");

  return _components[STDSTICK];
}




#if 0
void main(int argc,char*argv[])
{
  QApplication a(argc,argv);
  MyWidget *w;
  w=new MyWidget();
  w->resize(1000,200);
  
  a.setMainWidget(w);
  w->show();

  return (a.exec());
}
#endif
















