#include <qpixmap.h>
#include <qpainter.h>
#include <qtooltip.h>
#include <qdrawutl.h>

#include "QJBPTWidget.h"

QJBPTWidget::QJBPTWidget(QWidget *parent,
			   JBPT    *bpt)
  :QFrame(parent),
   _bpt(bpt)
{


  setFixedWidth(fontMetrics().width("000:0:000")+4);
  setFixedHeight(fontMetrics().height()+2);
  adjustSize();
  _pm = new QPixmap( width(), height() );   // used for flicker-free update
  bpt->attach(this);
  setBackgroundMode( PaletteBase );

  QToolTip::add(this," use: + - [ ] { } ALT ");
}


QJBPTWidget::~QJBPTWidget()
{
  delete _pm;
}

void
QJBPTWidget::keyPressEvent(QKeyEvent *event)
{

  int inc=1;

  debug(" keypress %c ",event->ascii());

  //  if (event->state() & ShiftButton)   inc *=10;
  if (event->state() & AltButton) inc *=10;

  switch(event->ascii()){
  case '+': 
    _bpt->addTicks(inc);
    break;

  case '-':
    _bpt->addTicks(-inc);
    break;

  case ']':
    _bpt->addPulses(inc);
    break;

  case '[':
    _bpt->addPulses(-inc);
    break;


  case '}':
    _bpt->addBars(inc);
    break;

  case '{':
    _bpt->addBars(-inc);
    break;

  default:
    event->ignore();
    break;
  }
}


void
QJBPTWidget::paintEvent(QPaintEvent *)
{
  paintText();
}

void
QJBPTWidget::paintText()
{

  QPainter p;
  p.begin( _pm );
  _pm->fill(QColor(255,255,255));
  _text.sprintf("%3d:%1d:%03d",_bpt->bar(),_bpt->pulse(),_bpt->tick());
  p.drawText(2,height()-1,_text);
  if (hasFocus()) {
    p.drawRect(0,0,width(),height());
  } else {
    // qDrawShadeRect(&p,0,0, width(), height(), colorGroup(),true,1,0,0);
  }


  p.end();

  bitBlt( this, 0, 0, _pm, 0, 0, width(), height() );
}


void 
QJBPTWidget::handle(const JBPT *bpt)
{
  assert(bpt == _bpt);
  update();
}





