#include "Piano.h"

#include <qapp.h>
#include <qbutton.h>
#include <qlabel.h>
#include <qframe.h>

#include <iostream.h>
#include "assert.h"
#include <ctype.h>


const char *PianoKey::KeyClassName="PianoKey";
QPoint tmp;

PianoKey::PianoKey(Octave* parent, int note, bool isblack) :
	QLabel(parent,KeyClassName) , _note(note), _isBlack(isblack)
{
	if (isblack) { // BlackKey

		setBackgroundColor(black);
		setLineWidth(2); 
//		raise();

	} else {

		setBackgroundColor(white);
		setLineWidth(2); 
//		lower();

	}
	KeyUp();
}
void PianoKey::mouseReleaseEvent(QMouseEvent* e)
{
	tmp=mapToGlobal( e->pos() );
	if (e->button() == LeftButton) {emit Up(&tmp);}
}
void PianoKey::mouseMoveEvent(QMouseEvent* e)
{
	tmp=mapToGlobal( e->pos() );
	if (e->state() & LeftButton) emit Move(&tmp);
}
void PianoKey::mousePressEvent(QMouseEvent* e)
{
	tmp=mapToGlobal( e->pos() );
	if (e->button() == LeftButton) {emit Down(&tmp);}
}
void PianoKey::KeyUp()
{
	//setFrameStyle(Panel|Raised); repaint(FALSE);
	setFrameStyle(WinPanel|Raised); repaint(FALSE);
}
void PianoKey::KeyDown()
{
	//setFrameStyle(Panel|Sunken); repaint(FALSE);
	setFrameStyle(WinPanel|Sunken); repaint(FALSE);
}


Octave::Octave(int baseNote, QWidget* parent, const char* name) :
	QWidget(parent,name) 
{
	static const bool bk[12]={0,1,0,1,0,0,1,0,1,0,1,0};
	int i=0; PianoKey *c=0; 
	for (i=0; i<12; i++) { 
		if (!bk[i]) {
			c=new PianoKey(this, baseNote+i , FALSE);  // White
			connect(c,SIGNAL(Down(QPoint*)),SIGNAL(Down(QPoint*)));
			connect(c,SIGNAL(Move(QPoint*)),SIGNAL(Move(QPoint*)));
			connect(c,SIGNAL(Up(QPoint*)),SIGNAL(Up(QPoint*)));
			keys[i]=c; 
		}
	}
	for (i=0; i<12; i++) { 
		if (bk[i]) {
			c=new PianoKey(this, baseNote+i , TRUE); // Black
			connect(c,SIGNAL(Down(QPoint*)),SIGNAL(Down(QPoint*)));
			connect(c,SIGNAL(Move(QPoint*)),SIGNAL(Move(QPoint*)));
			connect(c,SIGNAL(Up(QPoint*)),SIGNAL(Up(QPoint*)));
			keys[i]=c; 
		}
	}
}

PianoKey *
Octave::key(int i)
{
  assert(i >=0 && i < 12);
  return keys[i];
}

void Octave::resizeEvent(QResizeEvent*)
{
	static const int pl[12]={0,1,1,2,2,3,4,4,5,5,6,6};
	int w=width(),h=height();
	int bkw=w/10 , bkh=(h*3)/5 , wkw=w/7 , wkh=h;
	int i; PianoKey *c;

	for(i=0;i<12; i++ ) {  c=keys[i];
		if (c->isBlack()) {
			c->setGeometry((w*pl[i])/7-bkw/2,0,bkw,bkh);
		} else {
			c->setGeometry((w*pl[i])/7,0,wkw,wkh);
		}
	}
}


Piano::Piano(int nOctave,int baseNote,QWidget* parent, const char* name) :
	QWidget(parent,name),_nOctave(nOctave),_baseNote(baseNote)
{
	currentKey=0;

	int i; 

	Octave *o;

	for(i=0; i<_nOctave; i++) {
		o= new Octave(baseNote,this);
		connect(o,SIGNAL(Down(QPoint*)),this,SLOT(Down(QPoint*)));
		connect(o,SIGNAL(Move(QPoint*)),this,SLOT(Move(QPoint*)));
		connect(o,SIGNAL(Up(QPoint*)),this,SLOT(Up(QPoint*)));
		oct[i]=o; 
		baseNote += 12;
	}
}

void Piano::Down(QPoint* e)
{
	if (currentKey) { CHECK_PTR(0); }

	QWidget *who = QApplication::widgetAt(*e,TRUE);
	if (who && who->isA("PianoKey")) {
		emit noteOn( ((PianoKey*)who) -> note() );
		currentKey=(PianoKey*)who;
		currentKey->KeyDown();
	} else {
		currentKey=0;
	}

}


void Piano::Down(int note)
{
        note -= _baseNote;
        int io = (note)/12;
	if (io < 0 || io >= _nOctave) return;

        Octave *o = oct[io];
	note = note%12;
	PianoKey *key=o->key(note);
	key->KeyDown();
}


void Piano::Up(int note)
{
        note -= _baseNote;

        int io = note/12;
	if (io < 0 || io >= _nOctave) return;

        Octave *o = oct[io];
	note = note%12;
	PianoKey *key=o->key(note);
	key->KeyUp();
}


void Piano::Move(QPoint* e)
{
  QWidget *who = QApplication::widgetAt(*e,TRUE);
  if (who && who->isA("PianoKey")) {
    if (who != currentKey) {
      

      if (currentKey) { 
	emit noteOff( currentKey -> note() );
	currentKey->KeyUp();
      }

      emit noteOn( ((PianoKey *)who) -> note() );

      currentKey=(PianoKey*)who;
      currentKey->KeyDown();
    } else { 
      //			cout << "."; 
    }
  } else {
    if (currentKey) {
      emit noteOff( currentKey -> note() );
      currentKey->KeyUp();
      currentKey=0;
    }
  }
}
void Piano::Up(QPoint* e)
{
	QWidget *who = QApplication::widgetAt(*e,TRUE);
	if (who && who->isA("PianoKey")) {
		emit noteOff(((PianoKey*)who) -> note() );
		if (currentKey) { currentKey->KeyUp(); }
		currentKey=0;
	} else {
//		cout << "Silence continues \n";
	}
}


void Piano::resizeEvent(QResizeEvent*)
{
	int w=width(),h=height();
	int i;
	for (i=0; i<6; i++) {
		oct[i]->setGeometry((i*w)/6,0,w/6,h);
	}
}










