#include <string.h>
#include <math.h>  // pow
#include "JMidiBusDevice.h"

JMidiBusDevice::JMidiBusDevice()
  :JDevice("MidiBus")
{
	int argc = 0;
	char **argv = NULL;

	printf("connecting orb\n");
	CORBA::ORB_var orb = CORBA::ORB_init( argc, argv, "mico-local-orb" );
	CORBA::BOA_var boa = orb->BOA_init( argc, argv, "mico-local-boa" );

	printf("trying to bind\n");
	CORBA::Object_var obj =
		orb->bind ("IDL:MidiChannel:1.0", "inet:localhost:8888");
	if (CORBA::is_nil (obj)) {
		fprintf(stderr,"no midichannel object found, start synth_server or some other midibus aware\n");
		fprintf(stderr,"piece of software... ;)\n");
		exit(1);
	}

	printf("binding\n");
	midich = MidiChannel::_narrow (obj);
}

JMidiBusDevice::~JMidiBusDevice()
{
}



bool
JMidiBusDevice::handle(JMidiOutEvent e)
{
  // TODO work out what frequency of midi pitch 0 really is 
  
  if (e.type() != JMidiOutType::NOTE_EFFECT) return false;
  
  if (e.value() == 0)  {
	midich->noteOff(e.index(), e.value());
    return true;
  } else {
	// channel ?
	midich->noteOn(0, e.index(), e.value());
  }
  return true;
}













