#ifdef J_DEBUG
#include <iostream.h>
#endif

#include "JTrackNotator.h"       // I am
#include "JScorePainter.h"     // I use
#include "JTrack.h"
#include "JMeter.h"
#include "JBarIterator.h"
#include "JComposition.h"
#include "JPhrase.h"
#include "JBar.h"            
#include "JFocus.h"            // FOr hilight phrase
#include "rep/JLRRep.h"

JTrackNotator::JTrackNotator(const JTrack *track,
			     JScorePainter *painter)
  :   _scorePainter(painter),
      _track(track)
{


#ifdef J_DEBUG
  cout << " TrackNotator consruct " << endl;
#endif

}



void 
JTrackNotator::update(JLRRep lr1,JStyle style)
{

  if (_track == 0) return;



  _scorePainter->setName(_track->name());

  _scorePainter->clear(lr1);

  JLRRep lr(lr1.left()-JDuration(1), lr1.right()+JDuration(1));

  JBarIterator * barIter=0;

  const JComposition *comp = _track->composition();

  // Next call may change from and till.

  if (comp != 0) {
    const JMeter *meter = comp->meter();
    if ( meter != 0 ) {
      barIter = meter->createBarIterator(lr.left(),lr.right());
    }
  }

  if ( barIter != 0 ){
    const JBar *bar;
    while( (bar = barIter->next()) != 0 ) {
      //      cout << bar->beat() << " " << bar->number() << endl;
      _scorePainter->drawBar(bar->beat(),bar->number());
    }
  }

  if (barIter != 0 )  delete barIter;


  JPhraseListIterator iter(_track->phraseList());
  
  JPhrase *phrase;

  const JFocus *focus = _scorePainter->focus();
  
  assert(focus != 0);

  while( (phrase = iter.next()) != 0) {
    if (phrase != focus->phrase()) {
      JNotator *p=phrase->createNotator(_scorePainter);
      p->update(lr,DULL);
      delete p;
    }
  }

  phrase = focus->phrase();
  
  if (phrase != 0) {
    JNotator *p=phrase->createNotator(_scorePainter);
    p->update(lr,style);
    delete p;
  }

}















