

void
JNotator::visitGesture(JGesture *gesture)
{
  if (gesture->isType("Note")) {
    _scorePainter->drawNote(_note->start(),
			    _note->duration(),
			    _note->pitch(),
			    style);
  } 
}


void
JNotator::visitTrack(JTrack *track)
{
  if (track == 0) return;

  _scorePainter->setName(_track->name());

  _scorePainter->clear(lr1);

  JLRRep lr(lr1.left()-JDuration(1), lr1.right()+JDuration(1));

  JBarIterator * barIter=0;

  const JComposition *comp = _track->composition();

  // Next call may change from and till.

  if (comp != 0) {
    const JMeter *meter = comp->meter();
    if ( meter != 0 ) {
      barIter = meter->createBarIterator(lr.left(),lr.right());
    }
  }

  if ( barIter != 0 ){
    const JBar *bar;
    while( (bar = barIter->next()) != 0 ) {
      _scorePainter->drawBar(bar->beat(),bar->number());
    }
  }

  if (barIter != 0 )  delete barIter;


  JPhraseListIterator iter(_track->phraseList());
  
  JPhrase *phrase;

  while( (phrase = iter.next()) != 0) {
    if (phrase != _context->focus()->phrase()) {
      _hilight = DULL;
      visitPhrase(phrase);
    }
  }

  phrase = focus->phrase();
  
  if (phrase != 0) {
    _hilight = NORMAL ;
    visitPhrase(phrase);
  }
}

void
JNotator::visitPhrase(JPhrase *phrase)
{

  if (phrase == 0) return;
  JGestureListIterator iter(phrase->gestureList());
  
  const JGesture *hiGesture=0;

  JBeat left = _lr.left();

  if (_style == NORMAL) {
    if (phrase->controller() != 0 )
      hiGesture = phrase->controller()->focus();
  }

  JGesture *gesture;
  
  while( (gesture = iter.next()) != 0) {
    
    if (gesture->end() < left ) continue;
    
    if (gesture->start() > left) {
      _scorePainter->drawRest(left,gesture->start()-left);
    }

    if (left < gesture->end()) {
      left=gesture->end();
    }

    if ( gesture == hiGesture) {
      _mode = HILIGHT;
    } else {
      _mode = style;
    }

    visitGesture(gesture);

    if (gesture->start() > _lr.right()) break;

  }
}








