

void 
JTrackNotator::repairBars(JBeat from,
			  JBeat till,
			  bool wipe)
{

  if (wipe) {
    _scorePainter->clear(from,till);
  }

  JBarIterator * barIter=0;

  const JComposition *comp = _track->composition();

    // Next call may change from and till.
  if (comp != 0) {
    const JMeterTrack *meterTrack = comp->meterTrack();
    if ( meterTrack != 0 ) {
      barIter = meterTrack->createBarIterator(from,till);
    }
  }


  if ( barIter != 0 ){
    const JBar *bar;
    while( (bar = barIter->next()) != 0 ) {
      _scorePainter->drawBar(bar->beat(),bar->number());
    }
  }

  if (barIter != 0 )  delete barIter;

}

