#ifndef _MidiEvent_H
#define _MidiEvent_H


typedef struct _MidiEvent {
	int time;	/* tempo counter */
	int csec;	/* realtime csec counter */
	unsigned char channel, type;
	union {
		short par[2]; /* RPN events */
		int val; /* others */
		char *text; /* text message */
	} p;
} MidiEvent;

#define KeyOf(ev) ((ev)->p.par[0])
#define VelOf(ev) ((ev)->p.par[1])
#define CtrlOf(ev) ((ev)->p.par[0])
#define CValOf(ev) ((ev)->p.par[1])
#define BankOf(ev) ((ev)->p.par[0])
#define IsMSB(ev)  ((ev)->p.par[1])

#define FX_CUTOFF	0
#define FX_RESONANCE	1
#define FX_ATTACK	2
#define FX_RELEASE	3
#define FX_VIBRATE	4
#define FX_VIBDEPTH	5
#define FX_VIBDELAY	6
#define FX_NUMS		7

enum {
	MODE_GM = 0, MODE_MT32, MODE_MT32_INT, MODE_GS, MODE_XG,
	MODE_CMF, MODE_CMF2
};

#define MidiTempo(a,b,c) ((int)(a) * 65536 + (int)(b) * 256 + (int)(c))


/* Midi events */
enum {
	ME_NONE,
	ME_NOTEON, ME_NOTEOFF, ME_KEYPRESSURE, ME_CONTROL, 
	ME_PROGRAM, ME_CHNPRESSURE, ME_PITCHWHEEL,
	ME_TEMPO, ME_PITCH_SENS, ME_TONE_BANK,
	ME_ALL_SOUNDS_OFF, ME_RESET_CONTROLLERS, ME_ALL_NOTES_OFF,

	ME_LYRIC,

	ME_MASTER_VOLUME,

	ME_FINETUNE, ME_COARSETUNE,
	ME_AWE_FX, ME_GS_FX,
	
	ME_EOT,
};

/* default values */
#define MIDI_DEFAULT_TEMPO	500000

enum {
	EV_PLAY=0, EV_CONTROL, EV_SETSTAT, EV_STARTUP, EV_PRELOAD,
};

enum {
	SY_CHORUS_MODE, SY_REVERB_MODE,
};

#define DRUMBIT(ch)	(1 << (ch))	/* ch: 0 - 31 */

#endif






