#include "JSequence.h"
#include "seq/JSequencer.h"



class JMetroKnome:public JSequencer
{
public:
  JMetroKnome(JVoice *voice,int pitch):
    _voice(voice),
    _midiOnNote(pitch,70),
    _midiOffNote(pitch,0),
    _onNext(true),
    _nextBeat(JBeat::endOfTime())
  {;}

  /// Time of next event;
  JBeat nextBeat() 
  { return _nextBeat; }

  JBeat gotoBeat(const JBeat &when)
  { return _nextBeat=when; }

  JBeat execute();
private:
  JVoice *       _voice;
  JMidiNoteEvent _midiOnNote;
  JMidiNoteEvent _midiOffNote;
  bool           _onNext;
  JBeat          _nextBeat;
};

JBeat
MyTicker::execute()
{
  if (_onNext) {
    _voice->handle(_midiOnNote);
    _nextBeat += JDuration(0,3,4);
    _onNext = false;
  } else {
    _voice->handle(_midiOffNote);
    _nextBeat += JDuration(0,1,4);
    _onNext = true;
  }
  return _nextBeat;

}

class MyTick:public JSequence
{
public:
  MyTick(JVoice *voice):_voice(voice){;}
  JSequencer * createSequencer(JPlayer *) const;
  //  JEditor *editor() { return 0; }
private:
  JVoice * _voice;
};

JSequencer *
MyTick::createSequencer(JPlayer *) const
{
  return new MyTicker(_voice,56);  // COW BELL ??
}

