#ifndef _JGestureList_H
#define _JGestureList_H

#include "JSequenceListIterator.h"
#include "JDLL.h"
#include "JGesture.h"

class ostream;

class JGestureList
{
public:
  //! insert in correct place.
  JGestureList();
  ~JGestureList();
  
  JGestureList * clone();

  void insert(JGesture *);
  void append(JGesture *);
  void prepend(JGesture *);
  void deleteGesture(JGesture *);

  JGesture *head() { return _head;}
  JGesture *tail() { return _tail;}
  bool      write(ostream &) const;
  bool      read(JReader &);

private:

friend class JGestureListIterator;
  JGesture * _head;
  JGesture * _tail;
};


class JGestureListIterator: public JSequenceListIterator
{
public:

  JGestureListIterator(const JGestureList *gestureList);
  JGestureListIterator(JGesture *g);
  JGesture *next();
  JSequence *nextSequence();
private:

  JGesture * _next;
};


#endif

