#ifdef J_DEBUG
#include <iostream.h>
#endif

#include "JBeatToX.h"

JBeatToX::JBeatToX(int metric,
		   int x,
		   int width)
  :_qmetric(metric),
   _leftBeat(0),
   _jumpSmooth(0,1,8)
{
  set(x,width);
}

int 
JBeatToX::x(const JBeat &beat) const
{
  return (int)(_xZero+beat.rep()*_qmetric);
}

void
JBeatToX::set(int x,int width)
{
  _x=x;
  _width=width;
  setLeft(_leftBeat);
}

JBeat 
JBeatToX::beatAt(int x) const
{
  int x1=x-_xZero;
  int beats=x1/_qmetric;
  int n=x1%_qmetric;
  return JBeat(beats,n,_qmetric);
}



// Set the starting point.
void 
JBeatToX::setLeft(const JBeat &left)
{


  _leftBeat  = left;
  _rightBeat = JBeat(_leftBeat.rep() + (double)_width/(double)_qmetric);
  _xZero     = (int)(_x-(_leftBeat.rep()*_qmetric)); 

  _jump      = JDuration( 0.5*((double)_width)/(double)_qmetric );
  _tol       = JDuration( 0.2*((double)_width)/(double)_qmetric );

#ifdef J_DEBUG
  cout << "JBeatToX" << _leftBeat << _rightBeat << endl;
#endif

}

// Return the right hand.
JBeat  
JBeatToX::end() const
{
  return(_rightBeat);
}


// Return the left hand.
JBeat 
JBeatToX::start() const
{
  return(_leftBeat);
}



bool 
JBeatToX::setFocus(const JBeat &beat,bool smooth)
{


  if ( (beat + _tol) > end() ) {
    if (!smooth)  setLeft(beat - _jump);
    else  setLeft(beat - (_rightBeat - _leftBeat - _tol));
  } else if ( beat - _tol < start()) {
    if (!smooth) setLeft(beat - _jump);
    else  setLeft(beat - _tol);
  } else {
    return false;
  }
  
  return true;
}




bool
JBeatToX::setFocusAt(JBeat beat,int x)
{

  // (beat - left)* _qMetric  = x - _x

  JBeat left  = JBeat( beat.rep() - (double)(x - _x) / (double)_qmetric );

  if (left == _leftBeat) return false;

  setLeft(left);

  return true;
}














