#include <iostream.h>
#include <stdarg.h>

#include "japp/JApplication.h"  
#include "jam/JDeviceManager.h"  
#include "jam/JVoiceManager.h"  


#include "jam/JComposition.h"
#include "jam/JVoice.h"
#include "jam/JMidiIn.h"
#include "jam/JDevice.h"

#include "jam/JFocus.h"
#include "jam/JConductor.h"
#include "jam/JScheduler.h"
#include "jam/JMidiFileReader.h"
#include "jam/controls.h"


int main( int argc, char ** argv )
{

  assert(argc == 2);
  // Set up the devices

  JDeviceManager *manager=JDeviceManager::the();

  JApplication japp;

  int nDev = manager->nOutDevice();
  int i;

  cout << "\n Supported Devices" << endl;

  for(i=0; i < nDev ; i++ ) {
    cout << "[" << i << "] " <<  manager->outDevice(i)->name() << endl;
  }

  do {
    cout << " Enter the device you want to torture :";
    cin  >> i;
  } while (i <0 && i >= nDev);

  JVoiceManager::the()->setDefaultDevice(i);

  JComposition composition("Song");

  JMidiFileReader reader(&composition,argv[1]);

  reader.processFile();

  JConductor conductor(&composition);

  conductor.handle(JConductorCommand::START);


  cout << " <RET> to quit " << endl;

  char buff[2];
  cin.getline(buff,2);
  cin.getline(buff,2);

  
}










