#include <iostream.h>
#include <stdio.h>
#include <qapp.h>

#include <qsocknot.h>

#include "jam/JDeviceManager.h"  //  /dev/sequencer interface
#include "japp/JApplication.h"

#include "jam/JComposition.h"
#include "jam/JVoice.h"
#include "jam/JMidiIn.h"
#include "jam/JDevice.h"

#include "qj/QJMainWidget.h"
#include "qj/QJToolBox.h"

#include "jam/JMidiInController.h"
#include "jam/JVoiceManager.h"
#include "jam/JFocus.h"
#include "jam/JConductor.h"
#include "jam/JMapper.h"
#include "jam/JScheduler.h"
#include "jam/JMidiInDriver.h"
#include "jam/JContext.h"


int main( int argc, char ** argv )
{

  QApplication application( argc, argv );
  QApplication::setStyle(MotifStyle);
    
  new QJToolBox;

  // Set up the devices

  JApplication app;

  JDeviceManager *manager=JDeviceManager::the();

  JContext *context      = new JContext;
    
  JVoiceManager::the()->setConductor(context->conductor());
  
  JMidiIn *midiIn=0;

  if (manager->nInDevice() > 0) {
    midiIn=manager->midiIn(0);
  }

  JMidiInController *midiRoute=0;
    
  
  if (midiIn != 0) {
    // Make the midiIn follow the voice in focus
    midiRoute    = new JMidiInController(midiIn);
  }
    
  // Now the user interface.

    
  QJMainWidget mainWdgt(context);

  // 
  if (midiRoute != 0) context->focus()->attach(midiRoute);
    
  application.setMainWidget(&mainWdgt);

    
  mainWdgt.show();
    
  application.exec();
}










