#include <iostream.h>
#include "flowblk.h"
#include "beatblk.h"


// Default constructor
flow_block_c::flow_block_c(){
	 interval_int = 0;
	 no_notes_in_flow_int = 0;
	 flow_notes_array_ptr = 0;
	 start_beat_ptr = 0;
	 end_beat_ptr = 0;
}

// Other Constructor
flow_block_c::flow_block_c(int no_notes_in_flow_i, int *start_fraction_array_p,
									int *end_fraction_array_p){
	 char d;
	 interval_int = 0;
	 no_notes_in_flow_int = no_notes_in_flow_i;

	 start_beat_ptr = new beat_block_c(start_fraction_array_p);
	 if(start_beat_ptr == 0){
		cout << "FATAL ERROR: Cannot allocate memory..." << endl;
		cin.get(d);
	 }
	 end_beat_ptr = new beat_block_c(end_fraction_array_p);
	 if(end_beat_ptr == 0){
		cout << "FATAL ERROR: Cannot allocate memory..." << endl;
		cin.get(d);
	 }
	 if(no_notes_in_flow_int > 0){
		flow_notes_array_ptr = new int[no_notes_in_flow_int];
		if(flow_notes_array_ptr == 0){
		  cout << "FATAL ERROR: Cannot allocate memory..." << endl;
		  cin.get(d);
		}
	 }else
		flow_notes_array_ptr = 0;
}

void flow_block_c::remove_all(){
  if(flow_notes_array_ptr != 0){
	 if(no_notes_in_flow_int > 1)
		delete [] flow_notes_array_ptr;
	 else
		delete flow_notes_array_ptr;
  }
  if(start_beat_ptr != 0)
	 delete start_beat_ptr;
  if(end_beat_ptr != 0)
	 delete end_beat_ptr;
}
