#ifndef _JOSTemplate_H
#define _JOSTemplate_H


#ifdef J_DEBUG
#include <iostream.h>
#endif

#include "JHandler.h"
#include "JListTemplate.h"
#include "JName.h"

template<class M,class R> class JObserver;

template<class M,class R>
class JSubject:public virtual JNameBase
{
public:
  ///
  JSubject():_list(10),_doingIt(false){;}

  virtual ~JSubject();

  /// Add and remove Views.
  void		attach(JObserver<M,R> *v);
  void		detach(JObserver<M,R> *v);
  void          notifyObservers(M) const;
private:

  friend JObserver<M,R>;
  JList < JObserver <M,R> > _list;
  mutable bool   _doingIt;
};


template<class M,class R> 
class JObserver:public virtual JHandler<M,R>
{
public:

  JObserver():_list(25)
  {}

  ~JObserver()
  {
    JListIterator <JSubject<M,R> > iter(&_list);  
    JSubject<M,R> *s;
    
    while ( ( s=iter.next()) != 0) {
      bool flag=s->_list.remove(this);
      assert(flag);
    }
  }

  bool safeDetachFrom(JSubject <M,R> *s);
  
private:

friend JSubject<M,R>;

  JList < JSubject<M,R> > _list;

};



template<class M,class R>
inline
bool
JObserver<M,R>::safeDetachFrom(JSubject <M,R> *sub)
{

#ifdef J_DEBUG
  cout << " Deleting Subject " << endl;
#endif

  JListIterator<JSubject <M,R> > iter(&_list);  
  JSubject <M,R>  *s;
  while ( ( s=iter.next()) != 0) {
    if ( s == sub ) {
      sub->detach(this);
      return true;
    }
  }
  return false;
}


template<class M,class R>
inline
JSubject<M,R>::~JSubject()
{

#ifdef J_DEBUG
  cout << " Deleting Subject " << endl;
#endif

  JListIterator<JObserver <M,R> > iter(&_list);  
  JObserver <M,R>  *o;
  while ( ( o=iter.next()) != 0) {
    o->_list.remove(this);
  }

}

template<class M,class R>
inline
void
JSubject<M,R>::attach(JObserver<M,R> *o)
{

#ifdef J_DEBUG
  cout << " Attaching " << o->name() << " to " <<  name() <<endl;
#endif

    bool flag1=o->_list.add(this,true);
    bool flag2 = _list.add(o,true);

    assert( (flag1 && flag2)  || ((!flag2) && (!flag2)) );
}


template<class M,class R>
inline
void
JSubject<M,R>::detach(JObserver<M,R> *o)
{

#ifdef J_DEBUG
   cout << " Detaching " << endl;
#endif

  bool flag;

  flag=o->_list.remove(this);
  assert(flag);

  flag=_list.remove(o);
  assert(flag);
}

template<class M,class R>
inline
void
JSubject<M,R>::notifyObservers(M message) const 
{
  if (_doingIt) return;
  _doingIt = true;
  JListIterator<JObserver <M,R> > iter((JList< JObserver<M,R> > *)(&_list));  
  JObserver<M,R> *o;
  while ( ( o=iter.next()) != 0) {
    o->handle(message);
  }
  _doingIt = false;
}


#endif






