/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/rpc/sources/RCS/ui_rpcP.h,v $
  SHORTNAME      : ui_rpcP.h
  SNNS VERSION   : 4.0

  PURPOSE        : private header for ui_rpcP.h
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.5 $
  LAST CHANGE    : $Date: 1995/05/08 10:29:08 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#ifndef _UI_RPCP_DEFINED_
#define _UI_RPCP_DEFINED_

#ifndef INADDR_LOOPBACK
#define INADDR_LOOPBACK  (u_long)0x7F000001
#endif
#ifndef IN_SET_LOOPBACK_ADDR
#define IN_SET_LOOPBACK_ADDR(a)	{(a)->sin_addr.s_addr=htonl(INADDR_LOOPBACK);\
				 (a)->sin_family = AF_INET;}
#endif


/* Errors */
#define RPCERROR -1
#define RPCERROR_HOSTNOTFOUND -2


#define MAX_HOST_ENTRIES        100
#define MAX_HOST_LEN            60
#define MAX_PATH_LEN            60
#define MAX_PARAMETER_LEN       60
#define MAX_HOST_PANEL_SHOW     350
#define MAX_HOST_LEN_SHOW       50
#define MAX_PATH_LEN_SHOW       50
#define MAX_PARAMETER_LEN_SHOW  50
#define SWITCH_TO_LOCAL_ALL     5
#define SWITCH_TO_LOCAL_SINGLE  10
#define MAXWAITTIME             300
#define TIMEOUTSHORT            5

typedef struct {
        int     kernelid;
	u_int   pid;
        int     xguiid;
	char 	*hostname;
	char 	*domainname;
	char 	hostaddr[16];
	long    kernelno;
	char	*listentry;
	CLIENT  *cl;
	bool_t  hasKernelConfig;
	par_config *kernel_config; 
	/* For the control Panel */
	int     SubPatPanel; /* == -1 sup pattern panel so far never created
				==  0 not poped up right now
				==  1 poped up right now */
}hostentry;

/* 
 *The global RPC handle 
 */
extern struct timeval longtimeout;
extern struct timeval oldtimeout;
extern CLIENT *clienthandle;
extern char *akthostname;
extern par_config *kernel_config_ptr;

extern u_long kernelnummer;
extern u_long callbacknummer;
extern u_long prognummer;
extern hostentry host[MAX_HOST_ENTRIES+1];
extern char *hostnames[MAX_HOST_ENTRIES+1];
extern hostentry server[MAX_HOST_ENTRIES+1];
extern char *servernames[MAX_HOST_ENTRIES+1];
extern uint anzEntries;
extern uint anzHostEntries;
extern int aktlistpos;
extern int akthost;
extern int aktserver;
extern long minbroadcast;
extern long maxbroadcast;
extern long uid;
extern bool rpc_sendUpdateNet;
extern char str_idle[];
extern char str_learning[];
extern char itemsNames[MAX_HOST_PANEL_SHOW];

extern uint coopMaster;
extern bool_t coopModified;
extern uint anzCoopEntries;
extern parallel_kernel coopKernels[MAXPARAKERNELS+1];

extern int *ui_kernel_callback();
extern void ui_MakeHostList(void);
extern void ui_MakeServerList(void);
extern int ui_AppendServer(char *serv);
extern int ui_AppendHost(char *serv,char *doamin,char *addr,long kernelno,u_int pid,int xguiid, par_config *kernel_conf);
extern void ui_DeleteHost(u_int pos);
extern int ui_RPCswitchtoHost(int Hostnum,bool saveConfig);
extern char * ui_RPCmakeListEntry(int Hostnum,char *listentry);
extern char * ui_RPCchangeListEntry(int Hostnum);
extern void ui_RPCchangeControlPanel(void);
extern void ui_RPCchangeControlPanelValues(int fromHost,int toHost,bool saveConfig);
extern par_config *ui_RPCcreateKernelConfigEntry(void);
extern void ui_RPCsetSetupValues(void);
extern void ui_RPCstoreSetupValues(void);
extern int ui_CheckKernelID(int id);
extern int ui_RPCCallGET_SNNS_KERNEL(struct sockaddr_in *addr,long vers,char *serv);

#endif /* UI_RPCP */

