/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/rpc/sources/RCS/kr_ui_rpc.x,v $
  SHORTNAME      : kr_ui_rpc.x
  SNNS VERSION   : 4.0

  PURPOSE        : Inputfile for rpcgen
  NOTES          : The kernelfunctions for normal + master kernels

  AUTHOR         : Sven Doering
  DATE           : 17.08.94

  CHANGED BY     :
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.7 $
  LAST CHANGE    : $Date: 1995/05/08 10:29:08 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/
%#include <sys/time.h>
%#include <sys/param.h>         /* MAXHOSTNAMELEN */
#ifdef RPC_HDR
%static char null_ptr[]="THIS IS A RPC-NULLPOINTER";
#endif

%#define NORMALKERNEL     0
%#define COOP_M_KERNEL    1
%#define COOP_S_KERNEL    2
%
%/* Options to set */
%#define KERNELMODE             0
%#define PERMISSIONS            1
%#define TIMERVALUE             2
%#define ACTTIMERVALUE          3
%#define FILEBLOCKSIZE 524288
#define FILEBLOCKSIZE 524288


%#define TRANSFERNETWORK     0x0001
%#define TRANSFERPATTERN     0x0002
%#define RPC_PUT             0x0F00
%#define RPC_GET             0xF000

/* Status of the Kernel */
%#define  S_IDLE     0
%#define  S_LEARNING 1
%#define  S_UPDATE   2
%#define  S_TEST     3
%#define  S_SAVE     4
%#define  S_LOAD     5
%#define  S_READY    6
%#define  S_ERROR    7

/* Matrix Type */
%#define VAL_WEIGHT 1
%#define VAL_BIAS   2


/*
 * Typedefintions
 */
#define MAXSTRING 1024
#define NO_OF_LEARN_PARAMS 10
#define NO_OF_RESULTS 10
#define NO_OF_STORED_ERRORS 50
%#define MAXPARAKERNELS 10
#define MAXPARAKERNELS 10


typedef float   rpc_FlintType;
typedef float   rpc_FlintTypeParam;
typedef int     rpc_krui_err;
typedef char    *stringp;
typedef float   *floatp;


typedef long rpc_DIRP;

struct rpc_timeval {
        long    tv_sec;         /* seconds */
        long    tv_usec;        /* and microseconds */
};


struct par_get_kernel {
        string xguihost<>;
        long   xguipnumber;
        long   xguiversion;
        long   xguiid;
        long   uid;
        long   pid;
};

struct  rpc_dirent {
        long            d_off;          /* offset of next disk dir entry */
        unsigned long   d_fileno;       /* file number of entry */
        unsigned short  d_reclen;       /* length of this record */
        unsigned short  d_namlen;       /* length of string in d_name */
        string          d_name<>;       /* name (up to MAXNAMLEN + 1) */
        bool            last_entry;     /* detect end of dir */
};
struct par_getcwd {
        string buf<>;
        int size;
};
struct par_access {
        string path<>;
        int mode;
};

struct res_stat{
        short           st_dev;
        unsigned long   st_ino;
        unsigned short  st_mode;
        short           st_nlink;
        unsigned short  st_uid;
        unsigned short  st_gid;
        short           st_rdev;
        long            st_size;
        long            st_atime;
        long            st_mtime;
        long            st_ctime;
        long            st_blksize;
        long            st_blocks;
        int             return_value;
};



/****************************************************
 * ATTENTION this struct also exist in ui_rpcsnns.x
 *   as par_config2 and in kr_slave as sl_par_config
 ****************************************************/

struct par_config{

/* Configuration of the Kernel */
        u_int   lastEpoch;
        float   lastLearnError;
        u_int   epochsToLearn;
        long    starttime;
        long    cputime;
        int     kernelMode;
        rpc_timeval timeout;
        rpc_timeval timeoutlong;
        long    exittimeout;
        long    switchtolocalall;
        long    switchtolocalsingle;
        bool    isUDP;
        int     status;

/* current configuration of remote panel */
        int       ui_noOfCurrentPattern;  /* number of current pattern
                                         0 means, no patterns loaded */
        int       ui_patternLoadMode;
        int       ui_numberOfStepsDone;
        int       subIPatSize[5];
        int       subIPatPos[5];
        int       subIPatStep[5];
        int       subOPatStep[5];
        int       subOPatSize[5];
        int       subOPatPos[5];
        int       subIPatNo;
        int       subIPatDims;
        int       subOPatDims;
        float     ui_learnParameters[25];
        float     ui_updateParameters[5];
        float     ui_initParameters[5];
        bool      ui_shuffleFlg;

        /* from ui_fileP.ph */
        char   ui_filenameNET[100];
        char   ui_filenamePAT[100];
        char   ui_filenameRES[100];
        char   ui_filenameCFG[100];
        char   ui_filenameTXT[100];

        int    NO_OF_PATTERN_SETS;
        int    CURR_PATTERN_SET;
        char   PATTERN_SET_FILE[100];

        /* ui_remote.ph */
        int       ui_numberOfCycles;
        int       ui_numberOfSteps;

        /* are static */
        /* static int   INIT_KOHONEN_PRINT;
           static int   ui_noErrorArrayElements;
        */

        /* only for displaying */
        int noOfPatterns;
        int noOfUnits;
        int noOfInput;
        int noOfOutput;
        int noOfHidden;
};

struct parallel_kernel {
        int kernelid;   /* Id for the xgui host */
        long kernelno;  /* Versionnumber for portmapper */
        char coop_id;   /* Id for the master kernel */
        string host<>;
        string domain<>;
        string hostaddr<>;
        char status;
};

struct parallel_kernels {
        parallel_kernel kernels<>;
        int learnFunc;
        int noOfEpochs;
};

struct par_matrix {
        char val_type;
        float values<>;
};

struct res_matrix {
        char coop_id;
        char val_type;
        float error;
        float values<>;
};

struct par_learning {
        char coop_id;
        int startpat;
        int endpat;
        int learnFunc;
        int noOfEpochs;
};

struct par_coopLearning {
/*      int learningFunc;
        int noOfEpochs;*/
        par_learning from_to<MAXPARAKERNELS>;
};


struct res_send_kernel_msg {
        int     option;
        long    value;
        int     return_value;
};

struct par_filetransfer {
        long    epoche;
        long    laufnr;
        int     Command;
        bool    lastblock;
        long    bytes_used;
        opaque  fileblock[FILEBLOCKSIZE];
};

struct par_upload {
        int command;
        int setno;
        int epoche;
};

struct res_filetransfer {
        long    epoche;
        long    laufnr;
        int     Command;
        rpc_krui_err error;
        bool    lastblock;
        long    bytes_used;
        opaque  fileblock[FILEBLOCKSIZE];
};

struct par_NetLearnParameters{
    double parameter<>;
    int noOfParameters;
    int firstPattern;
    int lastPattern;
    int noOfEpochs;
};

struct res_NetLearnParameters{
    double              result<NO_OF_RESULTS>;
    int                 noOfResults;
    double              learnErrors<NO_OF_STORED_ERRORS>;
    int                 noOfErrors;
    rpc_krui_err        return_value;
/*    stringp           parameterDescription<>; not supported yet*/
};

struct res_getNetworkErrorArray{
    double              learnErrors<NO_OF_STORED_ERRORS>;
    int                 atEpoch<NO_OF_STORED_ERRORS>;
    int                 noOfErrors;
    rpc_krui_err        return_value;
};


struct rpc_pattern_set_info{
    int number_of_pattern;     /* the number of pattern (pairs) in           */
                               /* this set                                   */
    bool output_present;       /* TRUE if output pattern present             */
    bool fixed_fixsizes;       /* the fixsizes of all pattern are equal      */
    int in_fixsize;            /* if fixed_fixsizes TRUE, fixsize of         */
                               /* the input pattern, else -1                 */
    int out_fixsize;           /* if fixed_fixsizes TRUE, fixsize of         */
                               /* the output pattern, else -1                */
    int in_number_of_dims;     /* number of variable input dimensions        */
    int out_number_of_dims;    /* number of variable output dimensions       */
    int in_max_dim_sizes<>;    /* maximum values of         */
                               /* the input dimension       */
    int out_max_dim_sizes<>;   /* maximum values of the     */
                               /* output dimension          */
    int in_min_dim_sizes<>;    /* minimum values of the     */
                               /* input dimensions          */
    int out_min_dim_sizes<>;   /* minimum values of the     */
                               /* output dimensions         */
};

struct rpc_pattern_descriptor{
    int input_dim;             /* number of variable input dimensions        */
    int input_dim_sizes<>;     /* actual sizes of the input  */
                               /* dimensions                 */
    int input_fixsize;         /* size of the fixed part of the in pattern   */
                               /* or 0 if no input pattern present           */
    float input_pattern<>;     /* pointer to the input pattern data          */
    string input_info<>;       /* pointer to an optional info string         */
    int output_dim;            /* number of variable output dimensions       */
    int output_dim_sizes<>;    /* actual sizes of the output */
                               /* dimensions                 */
    int output_fixsize;        /* size of the fixed part of the out pattern  */
                               /* or 0 if no output pattern present          */
    float output_pattern<>;    /* pointer to the output pattern data         */
    string output_info<>;      /* pointer to an optional info string         */
};


struct kernel_info {
    int             errornr;
    int             uid;
    int             pid;
    int             port;
    string          hostname < MAXHOSTNAMELEN >;
    string          hostadr < 16 >;
};

/*
 * 3D-Kernel Definitions
 */

struct rpc_PosType {
    short           x;
    short           y;
    short           z;
};


struct rpc_PositionVector {
    float           x;
    float           y;
    float           z;
    float           w;
};

/*
 * kr_ui Functionparameter Definitions
 */

struct par_setUnitName {
    int             unit_no;
    string          unit_name<>;
};

struct par_setUnitOutFunc {
    int             unit_no;
    string          unitOutFuncName<>;
};

struct par_setUnitActFunc {
    int            unit_no;
    string         unitActFuncName<>;
};

struct par_setUnitActivation {
    int             UnitNo;
    rpc_FlintTypeParam  unit_activation;
};

struct par_setUnitInitialActivation {
    int             UnitNo;
    rpc_FlintTypeParam  unit_i_activation;
};

struct par_setUnitOutput {
    int             unit_no;
    rpc_FlintTypeParam  unit_output;
};

struct par_setUnitBias {
    int             UnitNo;
    rpc_FlintTypeParam  unit_bias;
};

struct par_setUnitValueA {
        int         UnitNo;
        rpc_FlintTypeParam unit_valueA;
};

struct par_setUnitSubnetNo {
    int             UnitNo;
    int             subnet_no;
};

struct par_setUnitLayerNo {
    int             UnitNo;
    int             layer_no;
};

struct par_getUnitPosition {
    int             UnitNo;
    struct rpc_PosType *position;
};

struct res_getUnitPosition {
    struct rpc_PosType position;
};

struct par_setUnitPosition {
    int             UnitNo;
    struct rpc_PosType *position;
};

struct par_getUnitNoAtPosition {
    struct rpc_PosType *position;
    int             subnet_no;
};

struct par_getUnitNoNearPosition {
    struct rpc_PosType *position;
    int             subnet_no;
    int             range;
    int             gridWidth;
};

struct par_setUnitTType {
    int             unit_no;
    int             UnitTType;
};

struct par_createUnit {
    string           unit_name<>;
    string           out_func_name<>;
    string           act_func_name<>;
    rpc_FlintTypeParam  i_act;
    rpc_FlintTypeParam  bias;
};

struct par_deleteUnitList {
    int             no_of_units;
    int             unit_list<>;
};

struct par_createFTypeUnit {
    string           Ftype_symbol<>;
};

struct par_setUnitFType {
    int            unit_no;
    string         Ftype_symbol<>;
};

struct par_copyUnit {
    int             unit_no;
    int             copy_mode;
};

struct par_createFTypeEntry {
    string           Ftype_symbol<>;
    string           act_func_name<>;
    string           out_func_name<>;
    int              no_of_sites;
    stringp          array_of_site_names<>;
};

struct res_getFuncInfo {
    string          func_name<>;
    int             func_type;
};

struct par_isFunction {
    string         func_name<>;
    int            func_type;
};

struct par_getFuncParamInfo {
    string         func_name<>;
    int            func_type;
    int            no_of_input_params;
    int            no_of_output_params;
};
struct res_getFuncParamInfo {
    bool           return_value;
    int            no_of_input_params;
    int            no_of_output_params;
};

struct par_getSiteTableEntry {
    string       site_name<>;
    string       site_func<>;
};
struct res_getSiteTableEntry {
    bool         return_value;
    string       site_name<>;
    string       site_func<>;
};


struct par_createSiteTableEntry {
    string           site_name<>;
    string           site_func<>;
};

struct par_changeSiteTableEntry {
    string           old_site_name<>;
    string           new_site_name<>;
    string           new_site_func<>;
};

struct res_Links {
    int            return_value;
    rpc_FlintType  strength;
};

struct res_Links_Bool {
    bool           return_value;
    rpc_FlintType  strength;
};

struct par_getFirstSuccUnit {
    int             source_unit_no;
    rpc_FlintType   weight;
};

struct par_getFirstLogSuccUnit {
    int             source_unit_no;
    rpc_FlintType   weight;
};

struct par_areConnected {
    int             source_unit_no;
    int             target_unit_no;
    rpc_FlintType   weight;
};

struct par_createLink {
    int             source_unit_no;
    rpc_FlintTypeParam  weight;
};

struct par_jogWeights {
    rpc_FlintTypeParam  minus;
    rpc_FlintTypeParam  plus;
};

struct par_updateNet {
    float           parameterInArray<>;
    int             NoOfInParams;
};

struct par_testNet {
    int            pattern_no;
    float          updateParameterInArray<>;
    int            updateNoOfInParams;
    float          parameterInArray<>;
    int            NoOfInParams;
};
struct res_testNet {
    rpc_krui_err   return_value;
    float          parameterOutArray<>;
    int            NoOfOutParams;
};

struct par_initializeNet {
    float          parameterInArray<>;
    int            NoOfInParams;
};

struct par_learnPatterns {
    float          parameterInArray<>;
    int            NoOfInParams;
    int            pattern_no;
};

struct res_learnPatterns {
    rpc_krui_err   return_value;
    float          parameterOutArray<>;
    int            NoOfOutParams;
};

struct res_allocNewPatternSet {
    rpc_krui_err   return_value;
    int            set_no;
};

struct par_allocatePatterns {
    int             no_of_input_patterns;
    int             no_of_output_patterns;
    int             no_of_pattern_pairs;
};

struct par_loadNewPatterns {
    string         filename<>;
};

struct res_loadNewPatterns {
    rpc_krui_err   return_value;
    int            number;
};

struct par_saveNewPatterns {
    string           filename<>;
    int              number;
};

struct res_getPatInfo {
    rpc_krui_err                return_value;
    rpc_pattern_set_info        set_info;
    rpc_pattern_descriptor      pat_des;
};

struct par_defShowSubPat {
    int            insize;
    int            outsize;
    int            inpos;
    int            outpos;
    rpc_krui_err   return_value;
};

struct par_defTrainSubPat {
    int            insize;
    int            outsize;
    int            instep;
    int            outstep;
    int            max_n_pos;
    rpc_krui_err   return_value;
};

struct par_alignSubPat {
    int            inpos;
    int            outpos;
    int            no;
    rpc_krui_err   return_value;
};

struct par_getShapeOfSubPattern {
    int            insize;
    int            outsize;
    int            inpos;
    int            outpos;
    int            n_pos;
    rpc_krui_err   return_value;
};

struct par_saveNet {
    string          filename<>;
    string          netname<>;
};

struct par_loadNet {
    string        filename<>;
};
struct res_loadNet {
    rpc_krui_err  return_value;
    string        netname<>;
};

struct par_saveResult {
    string          filename<>;
    bool            create;
    int             startpattern;
    int             endpattern;
    bool            includeinput;
    bool            includeoutput;
    float           Update_param_array<>;
};

struct res_getSymbolEntry {
    bool           return_value;
    string         symbol_name<>;
    int            symbol_type;
};

struct par_symbolSearch {
    string          symbol<>;
    int             symbol_type;
};

struct res_getNetInfo {
    rpc_krui_err   return_value;
    int            no_of_sites;
    int            no_of_links;
    int            no_of_STable_entries;
    int            no_of_FTable_entries;
};

struct res_getMemoryManagerInfo {
    rpc_krui_err   return_value;
    int            unit_bytes;
    int            site_bytes;
    int            link_bytes;
    int            NTable_bytes;
    int            STable_bytes;
    int            FTable_bytes;
};

struct res_getUnitDefaults {
    rpc_krui_err   return_value;
    rpc_FlintType       act;
    rpc_FlintType       bias;
    int                 st;
    int                 subnet_no;
    int                 layer_no;
    string              act_func<>;
    string              out_func<>;
};

struct par_setUnitDefaults {
    rpc_FlintTypeParam  act;
    rpc_FlintTypeParam  bias;
    int                 st;
    int                 subnet_no;
    int                 layer_no;
    string              act_func<>;
    string              out_func<>;
};

struct par_xyTransTable {
        int op;
        int x;
        int y;
        int z;
};

struct res_xyTransTable {
        rpc_krui_err   return_value;
        int x;
        int y;
};

struct par_getUnitCenters {
    int             unit_no;
    int             center_no;
    struct rpc_PositionVector unit_center;
};

struct res_getUnitCenters {
    rpc_krui_err        return_value;
    struct rpc_PositionVector unit_center;
};

struct par_setUnitCenters {
    int             unit_no;
    int             center_no;
    struct rpc_PositionVector unit_center;
};

struct par_na_error {
    int currentPattern;
    int error_unit;
    int error;
    bool ave;
};

/*
 * Functions
 */

program         SNNSKERNELPROG {
    version         SNNSKERNELVERS {
        /* These funktion are also in kr_slave.x as sl_... */
        int             GET_SNNS_KERNEL(par_get_kernel)                 = 1;
        string          GET_KERNEL_INFOTEXT(void)                       = 2;
        kernel_info     GET_KERNEL_INFO(void)                           = 3;
        rpc_DIRP        RPC_OPENDIR(string)                             = 4;
        rpc_dirent      RPC_READDIR(rpc_DIRP)                           = 5;
        int             RPC_CLOSEDIR(rpc_DIRP)                          = 6;
        string          RPC_GETCWD(par_getcwd)                          = 7;
        int             RPC_ACCESS(par_access)                          = 8;
        res_stat        RPC_STAT(string)                                = 9;
        int             SET_RPC_KERNEL_CONFIG(par_config)               = 10;
        par_config      GET_RPC_KERNEL_CONFIG(int)                      = 11;
        res_send_kernel_msg SEND_KERNEL_MSG(int)                        = 12;
        rpc_krui_err    DOWNLOAD_FILE(par_filetransfer)                 = 13;
        res_filetransfer UPLOAD_FILE(par_upload)                        = 14;
        int             SET_COOPCONFIG(parallel_kernels)                = 15;

        /* 75 - 100 reseverd for the slave funktions in kr_slave.x */
        int             SEND_PAR_MATRIX(par_matrix)                     = 75;
        int             SEND_RES_MATRIX(res_matrix)                     = 76;
        int             START_LEARNING(par_learning)                    = 77;
/*      int             BROAD_START_LEARNING(par_cooplearning)          = 78;*/

        /* Kernel Interfacefunctions */

        int             KRUI_GETNOOFUNITS(void)                         = 100;
        int             KRUI_GETFIRSTUNIT(void)                         = 101;
        int             KRUI_GETNEXTUNIT(void)                          = 102;
        int             KRUI_GETCURRENTUNIT(void)                       = 103;
        rpc_krui_err    KRUI_SETCURRENTUNIT(int)                        = 104;
        string          KRUI_GETUNITNAME(int)                           = 105;
        rpc_krui_err    KRUI_SETUNITNAME(par_setUnitName)               = 106;
        int             KRUI_SEARCHUNITNAME(string)                     = 107;
        int             KRUI_SEARCHNEXTUNITNAME(void)                   = 108;
        string          KRUI_GETUNITOUTFUNCNAME(int)                    = 109;
        rpc_krui_err    KRUI_SETUNITOUTFUNC(par_setUnitOutFunc)         = 110;
        string          KRUI_GETUNITACTFUNCNAME(int)                    = 111;
        rpc_krui_err    KRUI_SETUNITACTFUNC(par_setUnitActFunc)         = 112;
        string          KRUI_GETUNITFTYPENAME(int)                      = 113;
        rpc_FlintType   KRUI_GETUNITACTIVATION(int)                     = 114;
        rpc_krui_err    KRUI_SETUNITACTIVATION(par_setUnitActivation)   = 115;
        rpc_FlintType   KRUI_GETUNITINITIALACTIVATION(int)              = 116;
        void            KRUI_SETUNITINITIALACTIVATION(par_setUnitInitialActivation)     = 117;
        rpc_FlintType   KRUI_GETUNITOUTPUT(int)                         = 118;
        rpc_krui_err    KRUI_SETUNITOUTPUT(par_setUnitOutput)           = 119;
        rpc_FlintType   KRUI_GETUNITBIAS(int)                           = 120;
        void            KRUI_SETUNITBIAS(par_setUnitBias)               = 121;
        int             KRUI_GETUNITSUBNETNO(int)                       = 122;
        void            KRUI_SETUNITSUBNETNO(par_setUnitSubnetNo)       = 123;
        unsigned short  KRUI_GETUNITLAYERNO(int)                        = 124;
        void            KRUI_SETUNITLAYERNO(par_setUnitLayerNo)         = 125;
        res_getUnitPosition KRUI_GETUNITPOSITION(par_getUnitPosition)   = 126;
        void            KRUI_SETUNITPOSITION(par_setUnitPosition)       = 127;
        int             KRUI_GETUNITNOATPOSITION(par_getUnitNoAtPosition)               = 128;
        int             KRUI_GETUNITNONEARPOSITION(par_getUnitNoNearPosition)           = 129;
        int             KRUI_GETUNITTTYPE(int)                          = 130;
        rpc_krui_err    KRUI_SETUNITTTYPE(par_setUnitTType)             = 131;
        rpc_krui_err    KRUI_FREEZEUNIT(int)                            = 132;
        rpc_krui_err    KRUI_UNFREEZEUNIT(int)                          = 133;
        bool            KRUI_ISUNITFROZEN(int)                          = 134;
        int             KRUI_GETUNITINPUTTYPE(int)                      = 135;
        int             KRUI_CREATEDEFAULTUNIT(void)                    = 136;
        int             KRUI_CREATEUNIT(par_createUnit)                 = 137;
        rpc_krui_err    KRUI_DELETEUNIT(int)                            = 138;
        rpc_krui_err    KRUI_DELETEUNITLIST(par_deleteUnitList)         = 139;
        int             KRUI_CREATEFTYPEUNIT(string)                    = 140;
        rpc_krui_err    KRUI_SETUNITFTYPE(par_setUnitFType)             = 141;
        int             KRUI_COPYUNIT(par_copyUnit)                     = 142;
        bool            KRUI_SETFIRSTFTYPEENTRY(void)                   = 143;
        bool            KRUI_SETNEXTFTYPEENTRY(void)                    = 144;
        bool            KRUI_SETFTYPEENTRY(string)                      = 145;
        string          KRUI_GETFTYPENAME(void)                         = 146;
        rpc_krui_err    KRUI_SETFTYPENAME(string)                       = 147;
        string          KRUI_GETFTYPEACTFUNCNAME(void)                  = 148;
        rpc_krui_err    KRUI_SETFTYPEACTFUNC(string)                    = 149;
        rpc_krui_err    KRUI_SETFTYPEOUTFUNC(string)                    = 150;
        bool            KRUI_SETFIRSTFTYPESITE(void)                    = 151;
        bool            KRUI_SETNEXTFTYPESITE(void)                     = 152;
        string          KRUI_GETFTYPESITENAME(void)                     = 153;
        rpc_krui_err    KRUI_SETFTYPESITENAME(string)                   = 154;
        rpc_krui_err    KRUI_CREATEFTYPEENTRY(par_createFTypeEntry)     = 155;
        rpc_krui_err    KRUI_DELETEFTYPEENTRY(string)                   = 156;
        int             KRUI_GETNOOFFUNCTIONS(void)                     = 157;
        res_getFuncInfo KRUI_GETFUNCINFO(int)                           = 158;
        bool            KRUI_ISFUNCTION(par_isFunction)                 = 159;
        res_getFuncParamInfo KRUI_GETFUNCPARAMINFO(par_getFuncParamInfo)= 160;
        res_getSiteTableEntry KRUI_GETFIRSTSITETABLEENTRY(par_getSiteTableEntry)        = 161;
        res_getSiteTableEntry KRUI_GETNEXTSITETABLEENTRY(par_getSiteTableEntry)         = 162;
        string          KRUI_GETSITETABLEFUNCNAME(string)               = 163;
        rpc_krui_err    KRUI_CREATESITETABLEENTRY(par_createSiteTableEntry)             = 164;
        rpc_krui_err    KRUI_CHANGESITETABLEENTRY(par_changeSiteTableEntry)             = 165;
        rpc_krui_err    KRUI_DELETESITETABLEENTRY(string)               = 166;
        bool            KRUI_SETFIRSTSITE(void)                         = 167;
        bool            KRUI_SETNEXTSITE(void)                          = 168;
        rpc_krui_err    KRUI_SETSITE(string)                            = 169;
        rpc_FlintType   KRUI_GETSITEVALUE(void)                         = 170;
        string          KRUI_GETSITENAME(void)                          = 171;
        rpc_krui_err    KRUI_SETSITENAME(string)                        = 172;
        string          KRUI_GETSITEFUNCNAME(void)                      = 173;
        rpc_krui_err    KRUI_ADDSITE(string)                            = 174;
        bool            KRUI_DELETESITE(void)                           = 175;
        res_Links       KRUI_GETFIRSTPREDUNIT(rpc_FlintType)            = 176;
/*      res_Links       KRUI_GETFIRSTLOGPREDUNIT(rpc_FlintType)         = 177;*/
        res_Links       KRUI_GETNEXTPREDUNIT(rpc_FlintType)             = 178;
/*      res_Links       KRUI_GETNEXTLOGPREDUNIT(rpc_FlintType)          = 179;*/
        res_Links       KRUI_GETCURRENTPREDUNIT(rpc_FlintType)          = 180;
        res_Links       KRUI_GETFIRSTSUCCUNIT(par_getFirstSuccUnit)     = 181;
/*      res_Links       KRUI_GETFIRSTLOGSUCCUNIT(par_getFirstLogSuccUnit)= 182;*/
        res_Links       KRUI_GETNEXTSUCCUNIT(rpc_FlintType)             = 183;
/*      res_Links       KRUI_GETNEXTLOGSUCCUNIT(rpc_FlintType)          = 184;*/
        bool            KRUI_ARECONNECTED(par_areConnected)             = 185;
        bool            KRUI_ISCONNECTED(int)                           = 186;
        rpc_FlintType   KRUI_GETLINKWEIGHT(void)                        = 187;
        void            KRUI_SETLINKWEIGHT(rpc_FlintTypeParam)          = 188;
        rpc_krui_err    KRUI_CREATELINK(par_createLink)                 = 189;
        rpc_krui_err    KRUI_DELETELINK(void)                           = 190;
        rpc_krui_err    KRUI_DELETEALLINPUTLINKS(void)                  = 191;
        rpc_krui_err    KRUI_DELETEALLOUTPUTLINKS(void)                 = 192;
        void            KRUI_JOGWEIGHTS(par_jogWeights)                 = 193;
        rpc_krui_err    KRUI_UPDATESINGLEUNIT(int)                      = 194;
        string          KRUI_GETUPDATEFUNC(void)                        = 195;
        rpc_krui_err    KRUI_SETUPDATEFUNC(string)                      = 196;
        rpc_krui_err    KRUI_UPDATENET(par_updateNet)                   = 197;
        string          KRUI_GETINITIALISATIONFUNC(void)                = 199;
        rpc_krui_err    KRUI_SETINITIALISATIONFUNC(string)              = 200;
        rpc_krui_err    KRUI_INITIALIZENET(par_initializeNet)           = 201;
        string          KRUI_GETLEARNFUNC(void)                         = 202;
        rpc_krui_err    KRUI_SETLEARNFUNC(string)                       = 203;
        res_learnPatterns KRUI_LEARNALLPATTERNS(par_learnPatterns)      = 204;
        res_learnPatterns KRUI_LEARNSINGLEPATTERN(par_learnPatterns)    = 205;
        rpc_krui_err    KRUI_SHOWPATTERN(int)                           = 206;
        res_allocNewPatternSet KRUI_ALLOCNEWPATTERNSET(int)             = 207;
        rpc_krui_err    KRUI_NEWPATTERN(void)                           = 208;
        rpc_krui_err    KRUI_SETPATTERNNO(int)                          = 209;
        rpc_krui_err    KRUI_DELETEPATTERN(void)                        = 210;
        rpc_krui_err    KRUI_MODIFYPATTERN(void)                        = 211;
        void            KRUI_DELETEALLPATTERNS(void)                    = 212;
        rpc_krui_err    KRUI_SHUFFLEPATTERNS(bool)                      = 213;
        int             KRUI_GETNOOFPATTERNS(void)                      = 218;
        res_loadNewPatterns KRUI_LOADNEWPATTERNS(string)                = 219;
        rpc_krui_err    KRUI_SETCURRPATSET(int)                         = 220;
        rpc_krui_err    KRUI_SAVENEWPATTERNS(par_saveNewPatterns)       = 221;
        rpc_krui_err    KRUI_DELETEPATSET(int)                          = 222;
        res_getPatInfo  KRUI_GETPATINFO(void)                           = 223;
        par_defShowSubPat  KRUI_DEFSHOWSUBPAT(par_defShowSubPat)        = 224;
        par_defTrainSubPat KRUI_DEFTRAINSUBPAT(par_defTrainSubPat)      = 225;
        par_alignSubPat    KRUI_ALIGNSUBPAT(par_alignSubPat)            = 226;
        par_getShapeOfSubPattern KRUI_GETSHAPEOFSUBPATTERN(par_getShapeOfSubPattern)    = 227;
        rpc_krui_err    KRUI_SAVENET(par_saveNet)                       = 228;
        res_loadNet     KRUI_LOADNET(par_loadNet)                       = 229;
        rpc_krui_err    KRUI_SAVERESULTPARAM(par_saveResult)            = 232;
        rpc_krui_err    KRUI_ALLOCATEUNITS(int)                         = 233;
        void            KRUI_DELETENET(void)                            = 234;
        res_getSymbolEntry KRUI_GETFIRSTSYMBOLTABLEENTRY(void)          = 235;
        res_getSymbolEntry KRUI_GETNEXTSYMBOLTABLEENTRY(void)           = 236;
        bool            KRUI_SYMBOLSEARCH(par_symbolSearch)             = 237;
        string          KRUI_GETVERSION(void)                           = 238;
        res_getNetInfo  KRUI_GETNETINFO(void)                           = 239;
        res_getMemoryManagerInfo KRUI_GETMEMORYMANAGERINFO(void)        = 240;
        res_getUnitDefaults KRUI_GETUNITDEFAULTS(void)                  = 241;
        rpc_krui_err    KRUI_SETUNITDEFAULTS(par_setUnitDefaults)       = 242;
        void            KRUI_RESETNET(void)                             = 243;
        void            KRUI_SETSEEDNO(long)                            = 244;
        int             KRUI_GETNOOFINPUTUNITS(void)                    = 245;
        int             KRUI_GETNOOFOUTPUTUNITS(void)                   = 246;
        int             KRUI_GETNOOFTTYPEUNITS(int)                     = 247;
        res_xyTransTable KRUI_XYTRANSTABLE(par_xyTransTable)            = 248;
        res_getUnitCenters  KRUI_GETUNITCENTERS(par_getUnitCenters)     = 249;
        rpc_krui_err        KRUI_SETUNITCENTERS(par_setUnitCenters)     = 250;
        string          KRUI_ERROR(int)                                 = 251;
        rpc_krui_err    KRUI_SETSPECIALNETWORKTYPE(int)                 = 255;
        int             KRUI_GETSPECIALNETWORKTYPE(void)                = 256;
        rpc_FlintType   KRUI_GETUNITVALUEA(int)                         = 257;
        void  KRUI_SETUNITVALUEA(par_setUnitValueA)                     = 258;
        string          KRUI_GETFTYPEOUTFUNCNAME(void)                  = 259;
        res_Links_Bool  KRUI_ARECONNECTEDWEIGHT(par_areConnected)       = 260;
        res_NetLearnParameters KRUI_TRAINNETWORK(par_NetLearnParameters)= 261;
        res_getNetworkErrorArray KRUI_GETNETWORKERRORARRAY(void)        = 262;
        rpc_krui_err    KRUI_STOPTRAINING(void)                         = 263;
        int             KRUI_INITINVERSION(void)                        = 264;
        void            KRUI_INV_FORWARDPASS(void/*par_UnitList */)             = 265;
        double          KRUI_INV_BACKWARDPASS(void/*par_inv_backwardPass*/)     = 266;
        void            KRUI_KOHONEN_SETEXTRAPARAMETER(int)             = 267;
        void            KRUI_SPANNING_TREE(void)                        = 268;
        void            KRUI_CC_UPDATEPOSOFSPECIALUNITS(void)           = 269;
        rpc_krui_err    KRUI_CC_DELETEALLSPECIALUNITS(void)             = 270;
        int             KRUI_GETERRORCODE(void)                         = 271;
        rpc_krui_err    KRUI_SHUFFLESUBPATTERNS(bool)                   = 272;
        float           KRUI_GETVARIANCE(void)                          = 273;
        int             KRUI_COUNTLINKS(void)                           = 274;
        int             KRUI_CHECKPRUNING(void)                         = 275;
        res_learnPatterns KRUI_TESTALLPATTERNS(par_learnPatterns)       = 276;
        res_learnPatterns KRUI_TESTSINGLEPATTERN(par_learnPatterns)     = 277;
        res_learnPatterns KRUI_LEARNALLPATTERNSFF(par_learnPatterns)    = 278;
        res_learnPatterns KRUI_LEARNSINGLEPATTERNFF(par_learnPatterns)  = 279;
        string          KRUI_GETPRUNFUNC(void)                          = 280;
        rpc_krui_err    KRUI_SETPRUNFUNC(string)                        = 281;
        string          KRUI_GETFFLEARNFUNC(void)                       = 282;
        rpc_krui_err    KRUI_SETFFLEARNFUNC(string)                     = 283;
        int             KRUI_GETNOOFSPECIALINPUTUNITS(void)             = 284;
        int             KRUI_GETNOOFSPECIALOUTPUTUNITS(void)            = 285;
        float           KRUI_NA_ERROR(par_na_error)                     = 286;
    } =             40;    /* overwritten by the mainprog */
} =             0x211d1ae3;/* the adress for portmapper (same in kr_slave.x)*/
