/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/rpc/sources/RCS/kom_broadcast.ph,v $
  SHORTNAME      : kom_broadcast
  SNNS VERSION   : 4.0

  PURPOSE        : 
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.5 $
  LAST CHANGE    : $Date: 1995/05/12 09:13:37 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#ifndef _KOM_BROADCAST_DEFINED_
#define _KOM_BROADCAST_DEFINED_

/* begin global definition section */

#define MAX_BROADCAST_SIZE 7168

#define KOM_NOT_SEND 0
#define KOM_SEND     1
#define KOM_RCV      2

typedef struct {
	long 	pakets_recv;   /* the aktual number of Pakets received  */
	long 	last_paket_no; /* the number of the last received Paket */
	u_long  *paket_no;     /* the number of the pakets */
	int 	*status;       /* an Array with the status of the messages */
} send_control;

typedef struct {
	long	prognumber;
	long	versnumber;
	char    inet_addr[16];
} send_define_target;

typedef struct {
	long 	procnumber;
	xdrproc_t xdr_code;	
	xdrproc_t xdr_decode;
	caddr_t	msg_p;
	caddr_t res_p;
} send_define_msg;


typedef bool_t (*result_proc)(int msgNo,caddr_t res);

enum clnt_stat kom_clnt_broadcast(u_long prog, u_long vers, u_long proc, xdrproc_t xargs, caddr_t argsp);

enum clnt_stat kom_res_broadcast(int noOfTargets, send_define_target *targets, int noOfMsg, send_define_msg *messages, struct timeval timeout, struct timeval retry_timeout,send_control **status,result_proc res_proc);
	
/* end global definition section */

/* begin private definition section */


/* On some Systems missing pmap_rmt.h */
/* On SUN lowercase */
#ifndef _rpc_pmap_rmt_h
#define _rpc_pmap_rmt_h
/* On LINUX uppercase */
#ifndef _RPC_PMAP_RMT_H
#define _RPC_PMAP_RMT_H

struct rmtcallargs {
        u_long prog, vers, proc, arglen;
        caddr_t args_ptr;
        xdrproc_t xdr_args;
};

bool_t xdr_rmtcall_args();

struct rmtcallres {
        u_long *port_ptr;
        u_long resultslen;
        caddr_t results_ptr;
        xdrproc_t xdr_results;
};

bool_t xdr_rmtcallres();

#endif /* _RPC_PMAP_RMP_H */
#endif /*!_rpc_pmap_rmt_h*/


static struct timeval timeout = { 3, 0 };

static int kom_getbroadcastnets(struct in_addr *addrs, int sock, char *buf);

/* end private definition section */


#endif 





