/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/rpc/sources/RCS/kr_ui_rpc_main.ph,v $
  SHORTNAME      : kr_ui_rpc_main
  SNNS VERSION   : 4.0

  PURPOSE        : 
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.4 $
  LAST CHANGE    : $Date: 1995/04/21 14:20:36 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#ifndef _UI_RPC_MAIN_DEFINED_
#define _UI_RPC_MAIN_DEFINED_

/* begin global definition section */

void QuitKernel(int Mode);
/* Quit Modes */
#define NOSAVE  0
#define SAVENET 1

/* Errors */
#define NOERROR 0
#define TOMANYKERNELS -1

# define MAXKERNELS 9 /* MAX 99 */

/* How long stay running without connection to the world 1 = 1min */
#define TIMEOUTVAL 15
long timervalue=TIMEOUTVAL;
long acttimervalue=TIMEOUTVAL;

struct client {
    int xguiid;
    int kernelid;
    char *xguihost;
    long xguiprogramm;
    long xguiversion;
    int uid;
    int pid;
    int status;
    CLIENT *cl;
    long permissions;
};

int anzClients= -1;
int globalxguiid = 1;


/* Stores the kernel configuration */
bool_t config_received = FALSE;
par_config  kernel_config;
parallel_kernel m_coopKernels[MAXPARAKERNELS];
CLIENT *m_coopKernelsCl[MAXPARAKERNELS];
struct timeval m_coopKernelsStartT[MAXPARAKERNELS];
struct timeval m_coopKernelsLastT[MAXPARAKERNELS];
SVCXPRT global_trans;
SVCXPRT *global_transp = &global_trans;
int m_anzCoopKernels=0;
int kernelMode=NORMALKERNEL;
long rpcversion ;
/* is also declared in ui_rpcP.ph */
par_config  *kernel_config_ptr=&kernel_config;
bool_t patternloaded =FALSE;


#define MAXCLIENTS 10
struct client xguiclient;


bool_t isModifying(int req);
int make_xgui_callback(struct client *Client,int error);
void checkForRPCCalls(void);

/* end global definition section */


/* begin private definition section */
#ifdef __STDC__
#define SIG_PF void(*)(int)
#endif
static void _msgout(char* msg);

#ifdef __linux__
static int
sigtermcallback(int sig, int code,const struct sigaction * scp, struct sigaction *addr);
static int
sigpipecallback(int sig, int code,const struct sigaction * scp, struct sigaction *addr);
static int
sigalarmcallback(int sig, int code,const struct sigaction * scp, struct sigaction *addr);
static int
sigrpccallback(int sig, int code,const struct sigaction * scp, struct sigaction *addr);
#else
static void
sigalarmcallback(int sig, int code, struct sigcontext * scp, char *addr);
static void
sigpipecallback(int sig, int code, struct sigcontext * scp, char *addr);
static void
sigtermcallback(int sig, int code, struct sigcontext * scp, char *addr);
static void
sigrpccallback(int sig, int code, struct sigcontext * scp, char *addr);
#endif
static void checkall(struct svc_req *rqstp, register SVCXPRT *transp);

static int uid;


#ifndef INADDR_LOOPBACK
#define INADDR_LOOPBACK  (u_long)0x7F000001
#endif
#ifndef IN_SET_LOOPBACK_ADDR
#define IN_SET_LOOPBACK_ADDR(a)	{(a)->sin_addr.s_addr=htonl(INADDR_LOOPBACK);\
				 (a)->sin_family = AF_INET;}
#endif



#define OPT(str,pos) if( (strcmp(argv[pos],str))==0)

/* end private definition section */


#endif 





