/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/kernel/sources/RCS/strdup.c,v $
  SHORTNAME      : 
  SNNS VERSION   : 4.0

  PURPOSE        : System V Library Function strdup.
  NOTES          : The strdup function is missing in the ULTRIX-32 operating system
                    environment.

  AUTHOR         : Niels Mache
  DATE           : 30.07.90

  CHANGED BY     : Sven Doering
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 2.4 $
  LAST CHANGE    : $Date: 1995/03/14 14:00:52 $

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/

#ifdef NeXT
#include <stdio.h>
#include <strings.h>
#include <stdlib.h>

char *strdup(s1)
char *s1;
{
char *s2;
int l = strlen(s1) + 1;

if (s2 = (char *) malloc(l))
    strncpy(s2, s1, l);
return s2;
}

long lrand48()
{
return(random());
}

void srand48(seedval)
long seedval;
{
srandom(seedval);
}

double drand48()
{
return((double)random() / (double)2147483647);
}

#else

#ifndef ultrix
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#ifndef strdup
#define  strdup  bsd_strdup
#endif

#else

#ifdef ultrix
   /* DEC's pseudo ansi C-compiler doesn't understand const  */
#  define const
#endif

#include <stdlib.h>
#include <sys/types.h>
#include <stddef.h>
#include <string.h>
#include <memory.h>

#include "strdup.ph"

char *strdup(const char *str )
{
	int len;
	char *copy;

        len = strlen( str ) + 1;
#ifdef  __BORLANDC__
        if (!(copy = malloc((size_t)len)))
                return((char *)NULL);
        memcpy(copy, str, (size_t)len);
#else
	if (!(copy = malloc((unsigned int)len)))
                return((char *)NULL);
	bcopy(str, copy, len);
#endif
	return(copy);
}

#endif
#endif /* NeXT */
