MODULE KeyTest;

	(********************************************************)
	(*							*)
	(*		Test of keyboard driver.		*)
	(*							*)
	(*  Programmer:		P. Moylan			*)
	(*  Last edited:	2 October 1992			*)
	(*  Status:		OK				*)
	(*							*)
	(********************************************************)

FROM GlassTTY IMPORT
    (* proc *)	WriteString, WriteLn, WriteChar, SetCursor;

FROM KTrace IMPORT
    (* proc *)	InTrace, OutTrace, TraceOn;

FROM Keyboard IMPORT
    (* proc *)	InKey;
(*
IMPORT SpuriousInterrupts;
*)
IMPORT Timer;

(************************************************************************)

PROCEDURE RunTheTest;

    (* Keeps reading characters, and writing them on the screen, until	*)
    (* a termination character is detected.  In this version, we use	*)
    (* "\" as the termination character.				*)

    CONST TerminationCharacter = "\";

    VAR code: CHAR;  count: CARDINAL;

    BEGIN
	InTrace ("RunTheTest");
	SetCursor (0,0);  WriteString ("Test of keyboard driver.");
	WriteLn;
	count := 0;
	REPEAT
	    code := InKey();
	    IF code = CHR(13) THEN
		WriteLn;  count := 0;
	    ELSE
		WriteChar (code);
		INC (count);
		IF count = 80 THEN
		    WriteLn; count := 0;
		END (*IF*);
	    END(*IF*);
	UNTIL code = TerminationCharacter;

	WriteLn;
	WriteString ("End of test.");
	WriteLn;
	OutTrace ("RunTheTest");
    END RunTheTest;

(************************************************************************)
(*				MAIN PROGRAM				*)
(************************************************************************)

    BEGIN
(*	TraceOn (15, 24, 0, 79);*)
	RunTheTest;
    END KeyTest.
