/*********************************************************************
*              
* Name        : timing.h                  
* 
* Version     : 1.0
* 
* Description : Header file for the timing program of the
*               the wpi benchmark suite
* 
* Written by  : Brad Nichols
*
* e-mail      : mach@cs.wpi.edu
* 
* Address     : Mach Research Group
*               Worcester Polytechnic Institute 
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
* 
* Rev History :
*              
************************************************************************/


/*********************** SELECT TIMING METHOD ***********************/
/*                            systems
    timing          MACH 2.5    MACH 3.0   SCO V.3   SYS V.4
    ---------------------------------------------------------
    gettimeofday        X          X                    X
    getrusage           X          X                    
    ftime               X          X          X
    time                X          X          X         X
    times               X          X          X         X
    clock                                     X         X
*/

/*****************************************/
/* Uncomment the method of timing needed */
/* Note: Only one must be uncommented    */
/*****************************************/
#define GETTIMEOFDAY
/*#define GETRUSAGE */
/*#define FTIME*/
/*#define ATIME*/
/*#define TIMES*/
/*#define CLOCK*/


  /********************/
  /* DEFINE INCLUDES  */
  /********************/

#include <stdio.h>

#ifdef GETTIMEOFDAY
#include <sys/time.h>     
#endif GETTIMEOFDAY

#ifdef GETRUSAGE  
#include <sys/time.h>      
#include <sys/resource.h>  
#endif GETRUSAGE

#ifdef FTIME
#include <sys/types.h>
#include <sys/timeb.h>
#endif FTIME

#ifdef ATIME
#include <sys/types.h>
#include <sys/times.h>    
#endif ATIME

#ifdef TIMES
#include <sys/types.h>
#include <sys/times.h>    
#include <sys/param.h> 
#ifndef HZ
#define HZ 60
#endif 
#endif TIMES

struct my_timeval
{
  long tv_sec;
  long tv_usec;
  long sys_tv_sec;
  long sys_tv_usec;
  long user_tv_sec;
  long user_tv_usec;
};
