/****************************************************************************
*
* Name        : client_standalone.c  of X Interprocess Communication(IPC) Benchmark
*
*
* Description : This is the main client standalone program which is fork & execed by
*               mstandalone_client.c. 
*               The client connects with the X server. 
*               The client simulates the test results of actual clients like xdvi,
*               emacs etc by reproducing the sizes of the data sent by client and   
*               server.
*               The client uses data collected by Mr. Ralph E. Drom for the  
*               performance of the X window System Communication Protocol.
*               The client reads this data from a file. This data contains the 
*               number of bytes sent by the client as well as the number of bytes
*               the server has to reply with.
*
* Written by  : Dhruve Shah
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute (WPI)
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
************************************************************************/



#include <stdio.h>
#include <sys/file.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/param.h>
#include <arpa/nameser.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <resolv.h>
#include "defines.h"  
  
  
#define SERV_TCP_PORT   3278
  
  void client_do_transaction(); /* Client Transaction procedure */
int get_data();  /* Get data from file */
void get_initial_data(); /* Get initial data to begin transaction */
void sync_using_files(); /* Call function to synchoronize start of all client 
                          transactions */
FILE *fp, *fp1;          



main(argc, argv)
     int argc;
     char *argv[];
{
  
  int sockfd1; /* Client socket */
  struct sockaddr_in rm_server;  /* Structure for saving socket information */
  char temp_buf[100]; /* Temporary buffer used to synchronize remote and local clients */

/* Structure for storing timing information */

  struct my_timeval
    {
      long tv_sec;
      long tv_usec;
      long sys_tv_sec;
      long sys_tv_usec;
      long user_tv_sec;
      long user_tv_usec;
    };

/* Other timing related data structures. */

  struct my_timeval serv_start_time,serv_stop_time;
  int client_time;

/* Data structures for obtaining information for client requests and response */

  long Data_Size1, Data_Size2, loop, Which_Way1, Which_Way2;
  long Data_Size_tmp, Which_Way_tmp;
  struct sockaddr_in *rm;
  
/* Check if client is invoked with right number of arguments */
    
  if((argc != 5))
    {
      printf("Usage: client_standalone remote_hostname/local_hostname file num_remote client_no.\n");
      exit(-1);
    }

#ifdef DEBUG  
  printf("Server name is %s\n",argv[1]);
  printf("File name is %s\n",argv[2]);
  printf("Number of remote clients = %d\n",atoi(argv[3]));
  printf("Client number is %d\n",atoi(argv[4]));
#endif DEBUG  

  rm = &rm_server;

/* Make a socket and connect client to server using sockets */

  sockfd1 = initialize_client(argv[1],rm);
  
  fflush(stdout);
  fprintf(stdout,"Connect client %d succeeded\n",atoi(argv[4]));
  
  fflush(stdout);
  fprintf(stdout,"Client %d Started....\n",atoi(argv[4]));

/* get initial data to start of transaction */
  
  get_initial_data(&Data_Size1,&Which_Way1,&Data_Size2,&Which_Way2,argv[2]);

  timer_start_stop(&serv_start_time); /* Start timer */

  fflush(stdout);
  fprintf(stdout,"Performing client %d Transaction for %s....\n",atoi(argv[4]),argv[2]);

/* Perform complete transaction */

  client_do_transaction(sockfd1,Data_Size1, Which_Way1,Data_Size2, Which_Way2,TRUE,fp);

  fflush(stdout);
  fprintf(stdout,"Completed client %d Transaction\n",atoi(argv[4]));

  timer_start_stop(&serv_stop_time); /* Stop Timer */

#ifdef DEBUG
  client_time = display_timing(&serv_start_time,&serv_stop_time,"client time is  ");
#endif DEBUG

  close(sockfd1); /* Close socket */
  exit(0);
  
}

/************************************************************************************
 * This function reads in first two lines of data from various client data files    *
 * such as xdvi.data, emacs.data, twm.data, xwd.data etc.                           *
 ************************************************************************************/


void get_initial_data(Data_Size1,Which_Way1,Data_Size2,Which_Way2,name)
     long Which_Way1,Which_Way2,Data_Size1,Data_Size2;
     char *name;
{ 
  
  if(((int)fp = fopen(name,"r"))== NULL)
    {
      fprintf(stderr,"cannot open file xdvi.data\n");
      exit(1);
    }
  
  if(get_data(fp, &Data_Size1, &Which_Way1) == EOF)
    {
#ifdef DEBUG
      printf("CLIENT:File xdvi.data had no data\n");
#endif DEBUG
      exit(0);
    }
  
#ifdef DEBUG
  printf("Data_Size1 = %d and Which_Way1 = %d\n", Data_Size1, Which_Way1);
#endif DEBUG
  
  if(get_data(fp, &Data_Size2, &Which_Way2) == EOF)
    {
#ifdef DEBUG
      printf("CLIENT:File xdvi.data had no data\n");
#endif DEBUG
      exit(0);
    }
  
  
  
#ifdef DEBUG
  printf("Data_Size2 = %d and Which_Way2 = %d\n", Data_Size2, Which_Way2);
#endif DEBUG
}

int get_data(fp1, tmp1, tmp2)
     long *tmp1, *tmp2;
     int fp1;
{
  int temp;
  temp = fscanf(fp1, "%d %d\n", tmp1, tmp2);
  
  if(*tmp1 < 11)
    *tmp1 = 11;
  
  if(temp == EOF)
    return(EOF);
  else return(1);
  
}

/************************************************************************************
 * This function performs the transaction (Series of requests and responses) for the*
 * client.                                                                          *
 * The client simulates the test results of actual clients by reproducing the sizes *
 * of data sent by client and server from various data files.(xdvi.data etc).       *
 ************************************************************************************/

void client_do_transaction(s,len,Which_Way1,ret,Which_Way2,more_data,fp1)
     int s;
     int Which_Way1,Which_Way2;
     FILE *fp1;
     long len, ret;
     int more_data;
{
  
  char buffer[MAXDATA], temp1[5];
  char tmp1[10];
  int i, rcv_size, snd_size;
  int loop,Data_Size1,Data_Size2;
  

  loop = TRUE;
  while((loop == TRUE))
    {
      
      if(len > 0)
	{
	  sprintf(buffer,"%d:%d:%d:%d:%d",len, Which_Way1,ret,Which_Way2,more_data);
	  snd_size = send_data(s,buffer,len);
#ifdef DEBUG
	  printf("CLIENT: Successful in writing %d bytes in %d chars\n",snd_size,len);
#endif DEBUG
	}
      
      if(ret > 0)
	{
	  if(Which_Way2 > 0)
	    {
	      rcv_size = receive_data(s,buffer,ret);
#ifdef DEBUG
	      printf("CLIENT: Data received was %d bytes of %d chars\n",rcv_size,ret);
#endif DEBUG
	      
	    }
	  else
	    {
	      snd_size = send_data(s,buffer,ret);
#ifdef DEBUG
	      printf("CLIENT: Successful in writing %d bytes in %d chars\n",snd_size,len);
#endif DEBUG
	    }
	}
      if(get_data(fp1,&Data_Size1,&Which_Way1)== EOF)
	{
#ifdef DEBUG
	  printf("Client: File  had no data\n");
#endif DEBUG
	  len = 0;
	  ret = 0;
	  more_data = FALSE;
	  loop = FALSE;
	}
      else
	{
	  len = Data_Size1;
	}
      
      if(get_data(fp1,&Data_Size2,&Which_Way2)==EOF)
	{
	  ret = 0;
	  more_data = FALSE;
	  loop = FALSE;
	}
      else
	{
	  ret = Data_Size2;
	  more_data = TRUE;
	}
      
      if((more_data == FALSE) && (len == 0) && (ret == 0))
	{
	  sprintf(buffer,"%d:%d:%d:%d:%d",len, Which_Way1,ret,Which_Way2,more_data);
	  snd_size = send_data(s,buffer,24);
	  
#ifdef DEBUG
	  printf("CLIENT: Successful in writing %d bytes in %d chars\n",snd_size,len);
	  
	  printf("Last packet\n");
#endif DEBUG
	}
      
    }
  
}

/************************************************************************************
 * This function fills structure sockaddr_in with remote server address information.*
 * It creates a socket, connects to remote server and returns socket descriptor to  *
 * calling routine.                                                                 *
 ************************************************************************************/

initialize_client(host, remote_addr)
     struct sockaddr_in *remote_addr;
     char *host;
{
  int sock, t;
  
  mk_sock_addrin(remote_addr, host);
  sock = create_socket();
  t = connect_to_socket(sock, remote_addr);
  if(t < 0)
    {
      perror("connect");
      exit(-1);
    }
  return(sock);
}
